% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergingLibraries.R
\name{merging_libraries}
\alias{merging_libraries}
\title{Calls of expression in combined libraries}
\usage{
merging_libraries(
  userFile = NULL,
  approach = "BH",
  condition = "species_id",
  cutoff = 0.05,
  outDir = NULL,
  weights = FALSE
)
}
\arguments{
\item{userFile}{A file provided by the user with correspondent conditions}

\item{approach}{Approach used to do the merging of libraries}

\item{condition}{Condition/s where the merging should be done}

\item{cutoff}{Cutoff that should be applied to call Present/Absent genes}

\item{outDir}{Directory where the output files should be saved}

\item{weights}{Boolean to indicate if the user wants to use weights in the mean/median p-value calculation}
}
\value{
A dataframe containing the minimum quantitative value (p-value or q-value) and 
the calls to each gene id for the referent condition.
}
\description{
Merging/combine libraries based in a condition specified by the user.
The merging can be done using the p-values of the libraries, by applying the BH method,
or using the q-values of the libraries using the fdr_inverse method.
}
\examples{
\dontrun{
callsMerging_species <- merging_libraries(userFile = 'PATH_USER_FILE', approach = 'BH', 
condition = 'species_id', cutoff = 0.05, outDir = 'PATH_OUTPUT')
callsMerging_species_sex <- merging_libraries(userFile = 'PATH_USER_FILE', approach = 'fdr_inverse', 
condition = c(species_id, sex), cutoff = 0.01, outDir = 'PATH_OUTPUT')
callsMerging_all <- merging_libraries(userFile = 'PATH_USER_FILE', approach = 'fdr_inverse', 
condition = c(species_id, anatEntity, devStage, sex, strain), cutoff = 0.05, outDir = 'PATH_OUTPUT')
}

}
\author{
Sara Fonseca Costa

Alessandro Brandulas Cammarata
}
