% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_modules.R
\name{consensus_trait_cor}
\alias{consensus_trait_cor}
\title{Correlate set-specific modules and consensus modules to sample information}
\usage{
consensus_trait_cor(consensus, cor_method = "pearson", metadata_cols = NULL)
}
\arguments{
\item{consensus}{Consensus network returned by \code{consensus_modules}.}

\item{cor_method}{Correlation method to be used. One of 'spearman' or
'pearson'. Default: 'pearson'.}

\item{metadata_cols}{A vector (either numeric or character) indicating
which columns should be extracted from column metadata if \strong{exp}
is a `SummarizedExperiment` object. The vector can contain column
indices (numeric) or column names (character). By default, all columns are
used.}
}
\value{
Data frame of consensus module-trait correlations and p-values,
with the following variables:
\describe{
  \item{trait}{Factor, trait name. Each trait corresponds to a variable
               of the sample metadata (if numeric) or levels of a variable
               (if categorical).}
  \item{ME}{Factor, module eigengene.}
  \item{cor}{Numeric, correlation.}
  \item{pvalue}{Numeric, correlation P-values.}
  \item{group}{Character, name of the metadata variable.}
}
}
\description{
Correlate set-specific modules and consensus modules to sample information
}
\examples{
set.seed(12)
data(zma.se)
filt.zma <- filter_by_variance(zma.se, n=500)
zma.set1 <- filt.zma[, sample(colnames(filt.zma), size=20, replace=FALSE)]
zma.set2 <- filt.zma[, sample(colnames(filt.zma), size=20, replace=FALSE)]
list.sets <- list(zma.set1, zma.set2)
# SFT power previously identified with consensus_SFT_fit()
consensus <- consensus_modules(list.sets, power = c(11, 13),
                               cor_method = "pearson")
consensus_trait <- consensus_trait_cor(consensus, cor_method = "pearson")
}
