% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolutionary_analysis.R
\name{is_singleton}
\alias{is_singleton}
\title{Logical expression to check if gene or gene set is singleton or not}
\usage{
is_singleton(genes, og)
}
\arguments{
\item{genes}{Character containing gene or group of genes to be evaluated.}

\item{og}{Data frame of 3 columns corresponding to orthogroup, species ID,
and gene ID, respectively.}
}
\value{
Vector of logical values indicating if gene or group of genes
is singleton or not.
}
\description{
Logical expression to check if gene or gene set is singleton or not
}
\examples{
data(og.zma.osa)
data(filt.se)
genes <- tail(rownames(filt.se), n = 100)
is_singleton(genes, og.zma.osa)
}
\seealso{
\code{is_duplicated}
}
\author{
Fabricio Almeida-Silva
}
