% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcn_inference.R
\name{module_trait_cor}
\alias{module_trait_cor}
\title{Correlate module eigengenes to trait}
\usage{
module_trait_cor(
  exp,
  metadata,
  MEs,
  metadata_cols = NULL,
  cor_method = "pearson"
)
}
\arguments{
\item{exp}{A gene expression data frame with genes in row names and
samples in column names or a `SummarizedExperiment` object.}

\item{metadata}{A data frame containing sample names in row names and
sample annotation in the first column. Ignored if `exp` is
a `SummarizedExperiment` object, since the function will extract colData.}

\item{MEs}{Module eigengenes. It is the 2nd element of the result list
generated by the function \code{exp2gcn}.}

\item{metadata_cols}{A vector (either numeric or character) indicating
which columns should be extracted from column metadata if \strong{exp}
is a `SummarizedExperiment` object. The vector can contain column
indices (numeric) or column names (character). By default, all columns are
used.}

\item{cor_method}{Method to calculate correlation. One of 'pearson',
'spearman' or 'kendall'. Default is 'spearman'.}
}
\value{
A data frame with correlation and correlation p-values for each pair
of ME and trait, with the following variables:
\describe{
  \item{ME}{Factor, module eigengene.}
  \item{trait}{Factor, trait name. Each trait corresponds to a variable
               of the sample metadata (if numeric) or levels of a variable
               (if categorical).}
  \item{cor}{Numeric, correlation.}
  \item{pvalue}{Numeric, correlation P-values.}
  \item{group}{Character, name of the metadata variable.}
}
}
\description{
Correlate module eigengenes to trait
}
\examples{
data(filt.se)
gcn <- exp2gcn(filt.se, SFTpower = 18, cor_method = "pearson")
module_trait_cor(filt.se, MEs = gcn$MEs)
}
\author{
Fabricio Almeida-Silva
}
