% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocess.R
\name{PC_correction}
\alias{PC_correction}
\title{Apply Principal Component (PC)-based correction for confounding artifacts}
\usage{
PC_correction(exp, verbose = FALSE)
}
\arguments{
\item{exp}{A gene expression data frame with genes in row names
and samples in column names or a `SummarizedExperiment` object.}

\item{verbose}{Logical indicating whether to display progress
messages or not. Default: FALSE.}
}
\value{
Corrected expression data frame or `SummarizedExperiment` object.
}
\description{
Apply Principal Component (PC)-based correction for confounding artifacts
}
\examples{
data(zma.se)
exp <- filter_by_variance(zma.se, n=500)
exp <- PC_correction(exp)
}
\references{
Parsana, P., Ruberman, C., Jaffe, A. E., Schatz, M. C., Battle, A., &
Leek, J. T. (2019). Addressing confounding artifacts in reconstruction of
gene co-expression networks. Genome biology, 20(1), 1-6.
}
\seealso{
\code{\link[sva]{num.sv}},\code{\link[sva]{sva_network}}
}
\author{
Fabricio Almeida-Silva
}
