% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Richness.R
\name{hanabi}
\alias{hanabi}
\alias{hanabi,Rle-method}
\alias{hanabi,numeric-method}
\alias{hanabi,integer-method}
\alias{hanabi,GRanges-method}
\alias{hanabi,List-method}
\alias{hanabi,list-method}
\alias{hanabi,matrix-method}
\title{Calcultate richness in preparation for plotting}
\usage{
hanabi(
  x,
  n = 20,
  step = 0.75,
  from = NULL,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{hanabi}{Rle}(
  x,
  n = 20,
  step = 0.75,
  from = NULL,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{hanabi}{numeric}(
  x,
  n = 20,
  step = 0.75,
  from = NULL,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{hanabi}{integer}(
  x,
  n = 20,
  step = 0.75,
  from = NULL,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{hanabi}{GRanges}(
  x,
  n = 20,
  step = 0.75,
  from = NULL,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{hanabi}{List}(
  x,
  n = 20,
  step = 0.75,
  from = NULL,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{hanabi}{list}(
  x,
  n = 20,
  step = 0.75,
  from = NULL,
  useMulticore = FALSE,
  nrCores = NULL
)

\S4method{hanabi}{matrix}(
  x,
  n = 20,
  step = 0.75,
  from = NULL,
  useMulticore = FALSE,
  nrCores = NULL
)
}
\arguments{
\item{x}{An object contained expression counts on which richness scores can
be calculated.  For example an expression table in \code{DataFrame}
or \code{data.frame} format where columns are samples and rows are
featuressuch as genes, TSS, etc, or a vector of counts (tag counts,
molecule counts, ...), or \code{GRanges} or \code{GRangesList}
objects, etc.}

\item{n}{The maximum number of rarefactions per sample.}

\item{step}{Subsample sizes are calculated by taking the largest sample
and multiplying it by the step "n" times.}

\item{from}{Add one sample size (typically "0") in order to extend the
plot on the left-hand side.}

\item{useMulticore}{Logical, should multicore be used.
\code{useMulticore = TRUE} has no effect on non-Unix-like platforms.  At
the moment, it also has only effects on lists and list-derived classes
(data frames but not matrices).}

\item{nrCores}{Number of cores to use when \code{useMulticore = TRUE}
(set to \code{NULL} to use all detected cores).}
}
\value{
A list-based object of class "hanabi".
}
\description{
Rarefy data at multiple sample sizes using the
\code{vegan} package and return a \sQuote{hanabi} object that can be passed
to plot functions.

The computation can be long, so the steps of rarefaction and plotting are kept
separate.
}
\details{
This function does not take directly CAGEr objects as input,
because hanabi plots can be made from CTSS, clustered or gene-level
data, therefore it is not possible to guess which one to use.
}
\examples{
h <- hanabi(CTSStagCountDF(exampleCAGEexp))
h
plot(h)
hanabi(CTSStagCountGR(exampleCAGEexp, 2))
}
\seealso{
\code{vegan::rarecurve}.

Other CAGEr richness functions: 
\code{\link{hanabiPlot}()},
\code{\link{plot.hanabi}()}
}
\author{
Charles Plessy
}
\concept{CAGEr richness functions}
