% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{mod_gsea}
\alias{mod_gsea}
\alias{mod_gsea,CEMiTool-method}
\title{Module Gene Set Enrichment Analysis}
\usage{
mod_gsea(cem, ...)

\S4method{mod_gsea}{CEMiTool}(
  cem,
  gsea_scale = TRUE,
  rank_method = "mean",
  gsea_min_size = 15,
  gsea_max_size = 1000,
  verbose = FALSE
)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{gsea_scale}{If TRUE, transform data using z-score transformation. Default: TRUE}

\item{rank_method}{Character string indicating how to rank genes. Either "mean"
(the default) or "median".}

\item{gsea_min_size}{Minimum gene set size (Default: 15).}

\item{gsea_max_size}{Maximum gene set size (Default: 1000).}

\item{verbose}{logical. Report analysis steps.}
}
\value{
GSEA results.
}
\description{
Perfoms Gene Set Enrichment Analysis (GSEA) for each co-expression module found.
}
\examples{
# Get example CEMiTool object
data(cem)
# Look at example annotation file
sample_annotation(cem)
# Run GSEA on network modules
cem <- mod_gsea(cem)
# Check results
gsea_data(cem)

}
\seealso{
\code{\link{plot_gsea}}
}
