% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMB.R
\name{calTMB}
\alias{calTMB}
\title{calTMB}
\usage{
calTMB(
  maf,
  bedFile = NULL,
  bedHeader = FALSE,
  assay = "MSK-v3",
  genelist = NULL,
  mutType = "nonsynonymous",
  bedFilter = TRUE
)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{bedFile}{A file in bed format that contains region information.
Default: NULL.}

\item{bedHeader}{Whether the input bed file has a header or not. 
Default: FALSE.}

\item{assay}{Methodology and assay will be applied as a reference, including
'MSK-v3', 'MSK-v2', 'MSK-v1', 'FoundationOne', 'Pan-Cancer Panel' and
'Customized'. Default: 'MSK-v3'.}

\item{genelist}{A vector of panel gene list, only useful when assay is set to
'Customized'.}

\item{mutType}{A group of variant classifications that will be kept,
only useful when assay is set to 'Pan-Cancer Panel' or 'Customized',
including 'exonic', 'nonsynonymous'. and 'all' Default: 'nonsynonymous'.}

\item{bedFilter}{Whether to filter the information in bed file or not, which
only leaves segments in Chr1-Ch22, ChrX and ChrY. Default: TRUE.}
}
\value{
A TMB value.
}
\description{
Calculate Tumor Mutational Burden (TMB) in specific regions.
}
\examples{
maf <- vcfToMAF(system.file("extdata", "WES_EA_T_1_mutect2.vep.vcf",
package="CaMutQC"))
TMB_value <- calTMB(maf, bedFile=system.file("extdata/bed/panel_hg38",
"Pan-cancer-hg38.rds", package="CaMutQC"), assay = "Customized")
}
