% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterDB.R
\name{mutFilterDB}
\alias{mutFilterDB}
\title{mutFilterDB}
\usage{
mutFilterDB(
  maf,
  dbVAF = 0.01,
  ExAC = TRUE,
  Genomesprojects1000 = TRUE,
  ESP6500 = TRUE,
  gnomAD = TRUE,
  dbSNP = FALSE,
  keepCOSMIC = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{dbVAF}{Threshold of VAF value for database annotations. Default: 0.01.}

\item{ExAC}{Whether to filter variants listed in ExAC with VAF higher than
cutoff (set in dbVAF parameter). Default: TRUE.}

\item{Genomesprojects1000}{Whether to filter variants listed in
Genomesprojects1000 with VAF higher than cutoff (set in dbVAF parameter).
Default: TRUE.}

\item{ESP6500}{Whether to filter variants listed in ESP6500 with VAF higher
than cutoff (set in dbVAF parameter). Default: TRUE.}

\item{gnomAD}{Whether to filter variants listed in gnomAD with VAF higher
than cutoff (set in dbVAF parameter). Default: TRUE.}

\item{dbSNP}{Whether to filter variants listed in dbSNP. Default: FALSE.}

\item{keepCOSMIC}{Whether to keep variants in COSMIC even
they are present in germline database. Default: TRUE.}

\item{verbose}{Whether to generate message/notification during the 
filtration process. Default: TRUE.}
}
\value{
An MAF data frame after filtration for database
and clinical significance
}
\description{
Filter variants in germline database.
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutFilterDB(maf)
}
