% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutFilterTech.R
\name{mutFilterTech}
\alias{mutFilterTech}
\title{mutFilterTech}
\usage{
mutFilterTech(
  maf,
  PONfile = NULL,
  PONformat = "vcf",
  panel = "Customized",
  tumorDP = 20,
  normalDP = 10,
  tumorAD = 5,
  normalAD = Inf,
  VAF = 0.05,
  VAFratio = 0,
  dbsnpCutoff = 19,
  nonCutoff = 8,
  SBmethod = "SOR",
  SBscore = 3,
  maxIndelLen = 50,
  minInterval = 10,
  tagFILTER = "PASS",
  progressbar = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{maf}{An MAF data frame, generated by \code{\link{vcfToMAF}} function.}

\item{PONfile}{Panel-of-Normals files, which can be either obtained through 
GATK (https://gatk.broadinstitute.org/hc/en-us/articles/360035890631-Panel-of-Normals-PON-)
or generated by users. Should have at least four columns: CHROM, POS, REF, ALT
Defalut: NULL.}

\item{PONformat}{The format of PON file, either "vcf" or "txt". Default: "vcf"}

\item{panel}{The sequencing panel applied on the dataset. Parameters
for \code{\link{mutFilterQual}} function are set differently for different
panels. Default: "Customized". Options: "MSKCC", "WES".}

\item{tumorDP}{Threshold of tumor total depth. Default: 20}

\item{normalDP}{Threshold of normal total depth. Default: 10}

\item{tumorAD}{Threshold of tumor alternative allele depth. Default: 5}

\item{normalAD}{Threshold of normal alternative allele depth. Default: Inf}

\item{VAF}{Threshold of VAF value. Default: 0.05}

\item{VAFratio}{Threshold of VAF ratio (tVAF/nVAF). Default: 0}

\item{dbsnpCutoff}{Cutoff of normal depth for dbSNP variants. Default: 19.}

\item{nonCutoff}{Cutoff of normal depth for non-dbSNP variants. Default: 8.}

\item{SBmethod}{Method will be used to detect strand bias,
including 'SOR' and 'Fisher'. Default: 'SOR'. SOR: StrandOddsRatio
(https://gatk.broadinstitute.org/hc/en-us/articles/360041849111-
StrandOddsRatio)}

\item{SBscore}{Cutoff strand bias score used to filter variants.
Default: 3}

\item{maxIndelLen}{Maximum length of indel accepted to be included.
Default: 50}

\item{minInterval}{Minimum length of interval between an SNV and an indel
accepted to be included. Default: 10}

\item{tagFILTER}{Variants with specific tag in FILTER column will be kept,
set to NULL if you want to skip this filter. Default: 'PASS'}

\item{progressbar}{Whether to show progress bar when running this function
Default: TRUE}

\item{verbose}{Whether to generate message/notification during the 
filtration process. Default: TRUE.}
}
\value{
An MAF data frame after filtration for technical issue
}
\description{
Filter potential artifacts produced through technical issue,
including filtration for sequencing quality, strand bias, adjacent indel
tag, normal depth, panel of normal (PON) and FILTER field.
}
\examples{
maf <- vcfToMAF(system.file("extdata",
"WES_EA_T_1_mutect2.vep.vcf", package="CaMutQC"))
mafF <- mutFilterTech(maf, PONfile=system.file("extdata",
"PON_test.txt", package="CaMutQC"), PONformat="txt")
}
