% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytoProcessingStepImplementations.R
\name{readRDSObject}
\alias{readRDSObject}
\title{read RDS object}
\usage{
readRDSObject(RDSFile, ...)
}
\arguments{
\item{RDSFile}{a RDS file containing a R object
object}

\item{...}{other arguments (not used)}
}
\value{
the read R object
}
\description{
wrapper around readRDS, which discards any additional
parameters passed in (...)
}
\examples{

data(OMIP021Samples)

transListPath <- file.path(system.file("extdata", 
                                        package = "CytoPipeline"),
                           "OMIP021_TransList.rds") 

transList <- readRDSObject(transListPath)

ff_c <- compensateFromMatrix(OMIP021Samples[[1]],
                             matrixSource = "fcs")  

ff_t <- applyScaleTransforms(ff_c, transList = transList)

}
