% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_precision_recall.R
\name{predict_precision_recall}
\alias{predict_precision_recall}
\title{Predict precision-recall}
\source{
\href{https://stackoverflow.com/a/27796497}{
Fix for producing NAs from loess fun.}
}
\usage{
predict_precision_recall(
  pr_df,
  fun = stats::loess,
  precision = seq(10, 100, 10),
  recall = seq(10, 100, 10)
)
}
\arguments{
\item{pr_df}{Precision-recall data.frame generated by 
\link[EpiCompare]{precision_recall}.}

\item{fun}{Function to fit the data with.}

\item{precision}{Precision values to predict recall from.}

\item{recall}{Recall values to predict precision from.}
}
\value{
A named list of fitted models and predictions.
}
\description{
Predict specific values of precision or recall by fitting a model to
a precision-recall curve. 
Predictions that are <0 will automatically be set to 0.
Predictions that are >100 will automatically be set to 100.
}
\examples{
data("CnR_H3K27ac")
data("CnT_H3K27ac")
data("encode_H3K27ac")
peakfiles <- list(CnR_H3K27ac=CnR_H3K27ac, CnT_H3K27ac=CnT_H3K27ac)
reference <- list("encode_H3K27ac" = encode_H3K27ac)
pr_df <- precision_recall(peakfiles = peakfiles,
                          reference = reference)
predictions <- predict_precision_recall(pr_df = pr_df)           
}
