% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{CIS_volcano_plot}
\alias{CIS_volcano_plot}
\title{Trace volcano plot for computed CIS data.}
\usage{
CIS_volcano_plot(
  x,
  onco_db_file = "proto_oncogenes",
  tumor_suppressors_db_file = "tumor_suppressors",
  species = "human",
  known_onco = known_clinical_oncogenes(),
  suspicious_genes = clinical_relevant_suspicious_genes(),
  significance_threshold = 0.05,
  annotation_threshold_ontots = 0.1,
  highlight_genes = NULL,
  title_prefix = NULL,
  return_df = FALSE
)
}
\arguments{
\item{x}{Either a simple integration matrix or a data frame resulting
from the call to \link{CIS_grubbs} with \code{add_standard_padjust = TRUE}}

\item{onco_db_file}{Uniprot file for proto-oncogenes (see details).
If different from default, should be supplied as a path to a file.}

\item{tumor_suppressors_db_file}{Uniprot file for tumor-suppressor genes.
If different from default, should be supplied as a path to a file.}

\item{species}{One between \code{"human"}, \code{"mouse"} and \code{"all"}}

\item{known_onco}{Data frame with known oncogenes. See details.}

\item{suspicious_genes}{Data frame with clinical relevant suspicious
genes. See details.}

\item{significance_threshold}{The significance threshold}

\item{annotation_threshold_ontots}{Value above which genes are annotated
with colorful labels}

\item{highlight_genes}{Either \code{NULL} or a character vector of genes to be
highlighted in the plot even if they're not above the threshold}

\item{title_prefix}{A string or character vector to be displayed
in the title - usually the
project name and other characterizing info. If a vector is supplied,
it is concatenated in a single string via \code{paste()}}

\item{return_df}{Return the data frame used to generate the plot?
This can be useful if the user wants to manually modify the plot with
ggplot2. If TRUE the function returns a list containing both the plot
and the data frame.}
}
\value{
A plot or a list containing a plot and a data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Traces a volcano plot for IS frequency and CIS results.
}
\details{
\subsection{Input data frame}{

Users can supply as \code{x} either a simple integration matrix or a
data frame resulting from the call to \link{CIS_grubbs}.
In the first case an internal call to
the function \code{CIS_grubbs()} is performed.
}

\subsection{Oncogene and tumor suppressor genes files}{

These files are included in the package for user convenience and are
simply UniProt files with gene annotations for human and mouse.
For more details on how this files were generated use the help
\code{?tumor_suppressors}, \code{?proto_oncogenes}
}

\subsection{Known oncogenes}{

The default values are included in this package and
it can be accessed by doing:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{known_clinical_oncogenes()

}\if{html}{\out{</div>}}

If the user wants to change this parameter the input data frame must
preserve the column structure. The same goes for the \code{suspicious_genes}
parameter (DOIReference column is optional):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{clinical_relevant_suspicious_genes()

}\if{html}{\out{</div>}}
}
}
\section{Required tags}{

The function will explicitly check for the presence of these tags:
\itemize{
\item gene_symbol
}
}

\examples{
data("integration_matrices", package = "ISAnalytics")
cis_plot <- CIS_volcano_plot(integration_matrices,
    title_prefix = "PJ01"
)
cis_plot
}
\seealso{
Other Plotting functions: 
\code{\link{HSC_population_plot}()},
\code{\link{circos_genomic_density}()},
\code{\link{fisher_scatterplot}()},
\code{\link{integration_alluvial_plot}()},
\code{\link{sharing_heatmap}()},
\code{\link{sharing_venn}()},
\code{\link{top_abund_tableGrob}()},
\code{\link{top_cis_overtime_heatmap}()}
}
\concept{Plotting functions}
