% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISAnalytics-package.R
\docType{package}
\name{ISAnalytics}
\alias{ISAnalytics-package}
\alias{ISAnalytics}
\title{ISAnalytics: Analyze gene therapy vector insertion sites data
identified from genomics next generation sequencing reads for
clonal tracking studies}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
In gene therapy, stem cells are modified using viral
vectors to deliver the therapeutic transgene and replace functional
properties since the genetic modification is stable and inherited in
all cell progeny. The retrieval and mapping of the sequences flanking
the virus-host DNA junctions allows the identification of insertion
sites (IS), essential for monitoring the evolution of genetically
modified cells in vivo. A comprehensive toolkit for the analysis of
IS is required to foster clonal trackign studies and supporting the
assessment of safety and long term efficacy in vivo. This package
is aimed at (1) supporting automation of IS workflow, (2) performing
base and advance analysis for IS tracking (clonal abundance, clonal
expansions and statistics for insertional mutagenesis, etc.),
(3) providing basic biology insights of transduced stem cells in vivo.
}
\section{Useful resources}{

\itemize{
\item \href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC5702242/}{VISPA2:
A Scalable Pipeline for High-Throughput Identification
and Annotation of Vector Integration Sites}
}
}

\section{Vignettes}{

\itemize{
\item \code{vignette("workflow_start", package = "ISAnalytics")}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://calabrialab.github.io/ISAnalytics}
  \item \url{https://github.com//calabrialab/isanalytics}
  \item \url{https://calabrialab.github.io/ISAnalytics/}
  \item Report bugs at \url{https://github.com/calabrialab/ISAnalytics/issues}
}

}
\author{
\strong{Maintainer}: Francesco Gazzo \email{gazzo.francesco@hsr.it} (\href{https://orcid.org/0009-0000-4626-1386}{ORCID})

Authors:
\itemize{
  \item Giulia Pais \email{giuliapais1@gmail.com} (\href{https://orcid.org/0009-0005-5621-4803}{ORCID})
  \item Andrea Calabria \email{calabria.andrea@hsr.it}
  \item Giulio Spinozzi \email{spinozzi.giulio@hsr.it}
}

}
\keyword{internal}
