% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{mandatory_IS_vars}
\alias{mandatory_IS_vars}
\alias{vars_getters}
\alias{annotation_IS_vars}
\alias{association_file_columns}
\alias{iss_stats_specs}
\alias{matrix_file_suffixes}
\title{Current dynamic vars specifications getters.}
\usage{
mandatory_IS_vars(include_types = FALSE)

annotation_IS_vars(include_types = FALSE)

association_file_columns(include_types = FALSE)

iss_stats_specs(include_types = FALSE)

matrix_file_suffixes()
}
\arguments{
\item{include_types}{If set to \code{TRUE} returns both the names and the types
associated, otherwise returns only a character vector of names}
}
\value{
A character vector or a data frame
}
\description{
Fetches the look-up tables for different categories of dynamic
vars.
For more details, refer to the dedicated vignette
\code{vignette("workflow_start", package="ISAnalytics")}.
\itemize{
\item \code{mandatory_IS_vars} returns the look-up table of variables that are
used to uniquely identify integration events
}

\itemize{
\item \code{annotation_IS_vars()} returns the look-up table of variables that
contain genomic annotations
}

\itemize{
\item \code{association_file_columns()} returns the look-up table of variables that
contains information on how  metadata is structured
}

\itemize{
\item \code{iss_stats_specs()} returns the look-up table of variables that
contains information on the format of pool statistics files produced
automatically by VISPA2
}

\itemize{
\item \code{matrix_file_suffixes()} returns the look-up table of variables that
contains all default file names for each quantification type and it is
used by automated import functions
}
}
\examples{
# Names only
mandatory_IS_vars()

# Names and types
mandatory_IS_vars(TRUE)

# Names only
annotation_IS_vars()

# Names and types
annotation_IS_vars(TRUE)

# Names only
association_file_columns()

# Names and types
association_file_columns(TRUE)

# Names only
iss_stats_specs()

# Names and types
iss_stats_specs(TRUE)

# Names only
matrix_file_suffixes()

}
\seealso{
Other dynamic vars: 
\code{\link{inspect_tags}()},
\code{\link{pcr_id_column}()},
\code{\link{reset_mandatory_IS_vars}()},
\code{\link{set_mandatory_IS_vars}()},
\code{\link{set_matrix_file_suffixes}()}
}
\concept{dynamic vars}
