% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{top_cis_overtime_heatmap}
\alias{top_cis_overtime_heatmap}
\title{Heatmaps for the top N common insertion sites over time.}
\usage{
top_cis_overtime_heatmap(
  x,
  n_genes = 20,
  timepoint_col = "TimePoint",
  group_col = "group",
  onco_db_file = "proto_oncogenes",
  tumor_suppressors_db_file = "tumor_suppressors",
  species = "human",
  known_onco = known_clinical_oncogenes(),
  suspicious_genes = clinical_relevant_suspicious_genes(),
  significance_threshold = 0.05,
  plot_values = c("minus_log_p", "p"),
  p_value_correction = c("fdr", "bonferroni"),
  prune_tp_treshold = 20,
  gene_selection_param = c("trimmed", "n", "mean", "sd", "median", "mad", "min", "max"),
  fill_0_selection = TRUE,
  fill_NA_in_heatmap = FALSE,
  heatmap_color_palette = "default",
  title_generator = NULL,
  save_as_files = FALSE,
  files_format = c("pdf", "png", "tiff", "bmp", "jpg"),
  folder_path = NULL,
  ...
)
}
\arguments{
\item{x}{Output of the function \code{CIS_grubbs_overtime()}, either in single
data frame form or nested lists}

\item{n_genes}{Number of top genes to consider}

\item{timepoint_col}{The name of the time point column in \code{x}}

\item{group_col}{The name of the group column in \code{x}}

\item{onco_db_file}{Uniprot file for proto-oncogenes (see details).
If different from default, should be supplied as a path to a file.}

\item{tumor_suppressors_db_file}{Uniprot file for tumor-suppressor genes.
If different from default, should be supplied as a path to a file.}

\item{species}{One between \code{"human"}, \code{"mouse"} and \code{"all"}}

\item{known_onco}{Data frame with known oncogenes. See details.}

\item{suspicious_genes}{Data frame with clinical relevant suspicious
genes. See details.}

\item{significance_threshold}{The significance threshold}

\item{plot_values}{Which kind of values should be plotted? Can either be
\code{"p"} for the p-value or \code{"minus_log_p"} for a scaled p-value of the
Grubbs test}

\item{p_value_correction}{One among \code{"bonferroni"} and \code{"fdr"}}

\item{prune_tp_treshold}{Minimum number of genes to retain a time point.
See details.}

\item{gene_selection_param}{The descriptive statistic measure to decide
which genes to plot, possible choices are
\verb{"trimmed", "n", "mean", "sd", "median","mad", "min", "max"}. See details.}

\item{fill_0_selection}{Fill NA values with 0s before computing statistics
for each gene? (TRUE/FALSE)}

\item{fill_NA_in_heatmap}{Fill NA values with 0 when plotting the heatmap?
(TRUE/FALSE)}

\item{heatmap_color_palette}{Colors for values in the heatmaps,
either \code{"default"} or a function producing
a color palette, obtainable via \code{grDevices::colorRampPalette}.}

\item{title_generator}{Either \code{NULL} or a function. See details.}

\item{save_as_files}{Should heatmaps be saved to files on disk? (TRUE/FALSE)}

\item{files_format}{The extension of the files produced, supported
formats are \verb{"pdf", "png", "tiff", "bmp", "jpg"}. Relevant only if
\code{files_format = TRUE}}

\item{folder_path}{Path to the folder where files will be saved}

\item{...}{Other params to pass to \code{pheatmap::pheatmap}}
}
\value{
Either a list of graphical objects or a list of paths where
plots were saved
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function computes the visualization of the results of the function
\code{CIS_grubbs_overtime()} in the form of heatmaps for the top N selected
genes over time.
}
\details{
\subsection{Oncogene and tumor suppressor genes files}{

These files are included in the package for user convenience and are
simply UniProt files with gene annotations for human and mouse.
For more details on how this files were generated use the help
\code{?tumor_suppressors}, \code{?proto_oncogenes}
}

\subsection{Known oncogenes}{

The default values are included in this package and
it can be accessed by doing:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{known_clinical_oncogenes()

}\if{html}{\out{</div>}}

If the user wants to change this parameter the input data frame must
preserve the column structure. The same goes for the \code{suspicious_genes}
parameter (DOIReference column is optional):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{clinical_relevant_suspicious_genes()

}\if{html}{\out{</div>}}
}

\subsection{Top N gene selection}{

Since the genes present in different time point slices are likely different,
the decision process to select the final top N genes to represent in the
heatmap follows this logic:
\itemize{
\item Each time point slice is arranged either in ascending order (if we want to
plot the p-value) or in descending order (if we want to plot the scaled
p-value) and the top n genes are selected
\item A series of statistics are computed over the union set of genes on ALL
time points (min, max, mean, ...)
\item A decision is taken by considering the ordered \code{gene_selection_param}
(order depends once again if the values are scaled or not), and the first
N genes are selected for plotting.
}
\subsection{Filling NA values prior calculations}{

It is possible to fill NA values (aka missing combinations of GENE/TP) with
0s prior computing the descriptive statistics on which gene selection is
based. Please keep in mind that this has an impact on the final result,
since for computing metrics such as the mean, NA values are usually removed,
decreasing the overall number of values considered - this does not hold
when NA values are substituted with 0s.
}

\subsection{The statistics}{

Statistics are computed for each gene over all time points of each group.
More in detail, \code{n}: counts the number of instances (rows)
in which the genes appears, aka it counts the time points in which the gene
is present. NOTE: if
\code{fill_0_selection} option is set to \code{TRUE} this value will be equal for
all genes! All other statistics as per the argument \code{gene_selection_param}
map to the corresponding R functions with the exception of \code{trimmed} which
is a simple call to the \code{mean} function with the argument \code{trimmed = 0.1}.
}

}

\subsection{Aesthetics}{

It is possible to customise the appearence of the plot through different
parameters.
\itemize{
\item \code{fill_NA_in_heatmap} tells the function whether missing combinations of
GENE/TP should be plotted as NA or filled with a value (1 if p-value, 0
if scaled p-value)
\item A title generator function can be provided to dynamically create a title
for the plots: the function can accept two positional arguments for
the group identifier and the number of selected genes respectively. If one or
none of the arguments are of interest, they can be absorbed with \code{...}.
\item \code{heatmap_color_palette} can be used to specify a function from which
colors are sampled (refers to the colors of values only)
\item To change the colors associated with annotations instead, use the
argument \code{annotation_colors} of \code{pheatmap::pheatmap()} - it must be set to a
list with this format:
}

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
  KnownGeneClass = c("OncoGene" = color_spec,
                     "Other" = color_spec,
                     "TumSuppressor" = color_spec),
  ClinicalRelevance = c("TRUE" = color_spec,
                        "FALSE" = color_spec),
  CriticalForInsMut = c("TRUE" = color_spec,
                        "FALSE" = color_spec)
)
}\if{html}{\out{</div>}}
}
}
\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
cis_overtime <- CIS_grubbs_overtime(aggreg)
hmaps <- top_cis_overtime_heatmap(cis_overtime$cis,
    fill_NA_in_heatmap = TRUE
)

# To re-plot:
# grid::grid.newpage()
# grid::grid.draw(hmaps$PT001$gtable)
}
\seealso{
Other Plotting functions: 
\code{\link{CIS_volcano_plot}()},
\code{\link{HSC_population_plot}()},
\code{\link{circos_genomic_density}()},
\code{\link{fisher_scatterplot}()},
\code{\link{integration_alluvial_plot}()},
\code{\link{sharing_heatmap}()},
\code{\link{sharing_venn}()},
\code{\link{top_abund_tableGrob}()}
}
\concept{Plotting functions}
