% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions.R
\name{transform_columns}
\alias{transform_columns}
\title{Apply transformations to an arbitrary number of columns.}
\usage{
transform_columns(df, transf_list)
}
\arguments{
\item{df}{The data frame on which transformations should be operated}

\item{transf_list}{A named list of purrr-style lambdas, where names
are column names the function should be applied to.}
}
\value{
A data frame with transformed columns
}
\description{
This function takes a named list of purr-style lambdas where names are the
names of the columns in the data frame that must be transformed.
NOTE: the columns are overridden, not appended.
}
\details{
Lambdas provided in input must be transformations, aka functions that take
in input a vector and return a vector of the same length as the input.

If the input transformation list contains column names that are not present
in the input data frame, they are simply ignored.
}
\examples{
df <- tibble::tribble(
    ~A, ~B, ~C, ~D,
    1, 2, "a", "aa",
    3, 4, "b", "bb",
    5, 6, "c", "cc"
)
lambdas <- list(A = ~ .x + 1, B = ~ .x + 2, C = ~ stringr::str_to_upper(.x))
transform_columns(df, lambdas)
}
\seealso{
Other Utilities: 
\code{\link{as_sparse_matrix}()},
\code{\link{comparison_matrix}()},
\code{\link{enable_progress_bars}()},
\code{\link{export_ISA_settings}()},
\code{\link{generate_Vispa2_launch_AF}()},
\code{\link{generate_blank_association_file}()},
\code{\link{generate_default_folder_structure}()},
\code{\link{import_ISA_settings}()},
\code{\link{separate_quant_matrices}()}
}
\concept{Utilities}
