#' ISAnalytics: Analyze gene therapy vector insertion sites data
#' identified from genomics next generation sequencing reads for
#' clonal tracking studies
#'
#' @description
#' `r lifecycle::badge("stable")`
#' In gene therapy, stem cells are modified using viral
#' vectors to deliver the therapeutic transgene and replace functional
#' properties since the genetic modification is stable and inherited in
#' all cell progeny. The retrieval and mapping of the sequences flanking
#' the virus-host DNA junctions allows the identification of insertion
#' sites (IS), essential for monitoring the evolution of genetically
#' modified cells in vivo. A comprehensive toolkit for the analysis of
#' IS is required to foster clonal trackign studies and supporting the
#' assessment of safety and long term efficacy in vivo. This package
#' is aimed at (1) supporting automation of IS workflow, (2) performing
#' base and advance analysis for IS tracking (clonal abundance, clonal
#' expansions and statistics for insertional mutagenesis, etc.),
#' (3) providing basic biology insights of transduced stem cells in vivo.
#'
#' @section Useful resources:
#' * \href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC5702242/}{VISPA2:
#' A Scalable Pipeline for High-Throughput Identification
#' and Annotation of Vector Integration Sites}
#'
#' @section Vignettes:
#' * \code{vignette("workflow_start", package = "ISAnalytics")}
#'
#' @name ISAnalytics
#' @keywords internal
"_PACKAGE"

## usethis namespace: start
#' @import lifecycle
## usethis namespace: end
NULL
