% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{circos_genomic_density}
\alias{circos_genomic_density}
\title{Trace a circos plot of genomic densities.}
\usage{
circos_genomic_density(
  data,
  gene_labels = NULL,
  label_col = NULL,
  cytoband_specie = "hg19",
  track_colors = "navyblue",
  grDevice = c("png", "pdf", "svg", "jpeg", "bmp", "tiff", "default"),
  file_path = getwd(),
  ...
)
}
\arguments{
\item{data}{Either a single integration matrix or a list of integration
matrices. If a list is provided, a separate density track for each
data frame is plotted.}

\item{gene_labels}{Either \code{NULL} or a data frame in bed format. See details.}

\item{label_col}{Numeric index of the column of \code{gene_labels} that contains
the actual labels. Relevant only if \code{gene_labels} is not set to \code{NULL}.}

\item{cytoband_specie}{Specie for initializing the cytoband}

\item{track_colors}{Colors to give to density tracks. If more than one
integration matrix is provided as \code{data} should be of the same length.
Values are recycled if length of \code{track_colors} is smaller than the length
of the input data.}

\item{grDevice}{The graphical device where the plot should be traced.
\code{default}, if executing from RStudio is the viewer.}

\item{file_path}{If a device other than \code{default} is chosen, the path on
disk where the file should be saved. Defaults to
\verb{\{current directory\}/circos_plot.\{device\}}.}

\item{...}{Additional named arguments to pass on to chosen device,
\code{circlize::circos.par()},
\code{circlize::circos.genomicDensity()} and \code{circlize::circos.genomicLabels()}}
}
\value{
\code{NULL}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
For this functionality
the suggested package
\href{https://cran.r-project.org/web/packages/circlize/index.html}{circlize}
is required.
Please note that this function is a simple wrapper of basic \code{circlize}
functions, for an in-depth explanation on how the functions work and
additional arguments please refer to the official documentation
\href{https://jokergoo.github.io/circlize_book/book/}{Circular Visualization in R}
}
\details{
\subsection{Providing genomic labels}{

If genomic labels should be plotted alongside genomic density tracks,
the user should provide them as a simple data frame in standard bed format,
namely \code{chr}, \code{start}, \code{end} plus a column containing the labels.
NOTE: if the user decides to plot on the default device (viewer in RStudio),
he must ensure there is enough space for all elements to be plotted,
otherwise an error message is thrown.
}
}
\examples{
\donttest{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
by_subj <- aggreg |>
    dplyr::group_by(.data$SubjectID) |>
    dplyr::group_split()
circos_genomic_density(by_subj,
    track_colors = c("navyblue", "gold"),
    grDevice = "default", track.height = 0.1
)
}
}
\seealso{
Other Plotting functions: 
\code{\link{CIS_volcano_plot}()},
\code{\link{HSC_population_plot}()},
\code{\link{fisher_scatterplot}()},
\code{\link{integration_alluvial_plot}()},
\code{\link{sharing_heatmap}()},
\code{\link{sharing_venn}()},
\code{\link{top_abund_tableGrob}()},
\code{\link{top_cis_overtime_heatmap}()}
}
\concept{Plotting functions}
