% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-functions.R
\name{integration_alluvial_plot}
\alias{integration_alluvial_plot}
\title{Alluvial plots for IS distribution in time.}
\usage{
integration_alluvial_plot(
  x,
  group = c("SubjectID", "CellMarker", "Tissue"),
  plot_x = "TimePoint",
  plot_y = "fragmentEstimate_sum_PercAbundance",
  alluvia = mandatory_IS_vars(),
  alluvia_plot_y_threshold = 1,
  top_abundant_tbl = TRUE,
  empty_space_color = "grey90",
  ...
)
}
\arguments{
\item{x}{A data frame. See details.}

\item{group}{Character vector containing the column names that identify
unique groups.}

\item{plot_x}{Column name to plot on the x axis}

\item{plot_y}{Column name to plot on the y axis}

\item{alluvia}{Character vector of column names that uniquely identify
alluvia}

\item{alluvia_plot_y_threshold}{Numeric value. Everything below this
threshold on y will be plotted in grey and aggregated. See details.}

\item{top_abundant_tbl}{Logical. Produce the summary top abundant tables
via \link{top_abund_tableGrob}?}

\item{empty_space_color}{Color of the empty portion of the bars (IS below
the threshold). Can be either a string of known colors, an hex code or
\code{NA_character} to set the space transparent. All color
specs accepted in ggplot2
are suitable here.}

\item{...}{Additional arguments to pass on to \link{top_abund_tableGrob}}
}
\value{
For each group a list with the associated plot and optionally
the summary tableGrob
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Alluvial plots allow the visualization of integration sites distribution
in different points in time in the same group.
This functionality requires the suggested package
\href{https://corybrunson.github.io/ggalluvial/}{ggalluvial}.
}
\details{
\subsection{Input data frame}{

The input data frame must contain all the columns specified in the
arguments \code{group}, \code{plot_x}, \code{plot_y} and \code{alluvia}. The standard
input for this function is the data frame obtained via the
\link{compute_abundance} function.
}

\subsection{Plotting threshold on y}{

The plotting threshold on the quantification on the y axis has the
function to highlight only relevant information on the plot and reduce
computation time. The default value is 1, that acts on the default column
plotted on the y axis which contains a percentage value. This translates
in natural language roughly as "highlight with colors only those
integrations (alluvia) that at least in 1 point in time have an
abundance value >= 1 \%". The remaining integrations will be plotted
as a unique layer in the column, colored as specified by the argument
\code{empty_space_color}.
}

\subsection{Customizing the plot}{

The returned plots are ggplot2 objects and can therefore further modified
as any other ggplot2 object. For example, if the user decides to change the
fill scale it is sufficient to do

\if{html}{\out{<div class="sourceCode r">}}\preformatted{plot +
  ggplot2::scale_fill_viridis_d(...) + # or any other discrete fill scale
  ggplot2::theme(...) # change theme options
}\if{html}{\out{</div>}}

NOTE: if you requested the computation of the top ten abundant tables and
you want the colors to match you should re-compute them
}

\subsection{A note on strata ordering}{

Strata in each column are ordered first by time of appearance and secondly
in decreasing order of abundance (value of y). It means, for example,
that if the plot has 2 or more columns, in the second column, on top,
will appear first appear IS that appeared in the previous columns and then
all other IS, ordered in decreasing order of abundance.
}
}
\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
abund <- compute_abundance(x = aggreg)
alluvial_plots <- integration_alluvial_plot(abund,
    alluvia_plot_y_threshold = 0.5
)
ex_plot <- alluvial_plots[[1]]$plot +
    ggplot2::labs(
        title = "IS distribution over time",
        subtitle = "Patient 1, MNC BM",
        y = "Abundance (\%)",
        x = "Time point (days after GT)"
    )
print(ex_plot)
}
\seealso{
Other Plotting functions: 
\code{\link{CIS_volcano_plot}()},
\code{\link{HSC_population_plot}()},
\code{\link{circos_genomic_density}()},
\code{\link{fisher_scatterplot}()},
\code{\link{sharing_heatmap}()},
\code{\link{sharing_venn}()},
\code{\link{top_abund_tableGrob}()},
\code{\link{top_cis_overtime_heatmap}()}
}
\concept{Plotting functions}
