% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ibex_matrix.R
\name{Ibex_matrix}
\alias{Ibex_matrix}
\title{Ibex Matrix Interface}
\usage{
Ibex_matrix(
  input.data,
  chain = c("Heavy", "Light"),
  method = c("encoder", "geometric"),
  encoder.model = c("CNN", "VAE", "CNN.EXP", "VAE.EXP"),
  encoder.input = c("atchleyFactors", "crucianiProperties", "kideraFactors", "MSWHIM",
    "tScales", "OHE"),
  geometric.theta = pi/3,
  species = "Human",
  verbose = TRUE
)
}
\arguments{
\item{input.data}{Input data, which can be:
\itemize{
\item A Single Cell Object in Seurat or SingleCellExperiment format
\item The output of \code{\link[scRepertoire:combineBCR]{scRepertoire::combineBCR()}} or \code{\link[=combineExpandedBCR]{combineExpandedBCR()}}
}}

\item{chain}{Character. Specifies which chain to analyze:
\itemize{
\item "Heavy" for the heavy chain
\item "Light" for the light chain
}}

\item{method}{Character. The algorithm to use for generating latent vectors:
\itemize{
\item "encoder" - Uses deep learning autoencoders
\item "geometric" - Uses geometric transformations based on the BLOSUM62 matrix
}}

\item{encoder.model}{Character. The type of autoencoder model to use:
\itemize{
\item "CNN" - CDR3 Convolutional Neural Network-based autoencoder
\item "VAE" - CDR3 Variational Autoencoder
\item "CNN.EXP" - CDR1/2/3 CNN
\item "VAE.EXP" - CDR1/2/3 VAE
}}

\item{encoder.input}{Character. Specifies the input features for the encoder model. Options include:
\itemize{
\item Amino Acid Properties: "atchleyFactors", "crucianiProperties", "kideraFactors", "MSWHIM","tScales", "zScales"
\item "OHE" for One Hot Encoding
}}

\item{geometric.theta}{Numeric. Angle (in radians) for the geometric
transformation. Only used when \code{method = "geometric"}.}

\item{species}{Character. Default is "Human" or "Mouse".}

\item{verbose}{Logical. Whether to print progress messages. Default is TRUE.}
}
\value{
A matrix of latent vectors generated by the specified method.
}
\description{
This function runs the Ibex algorithm to generate latent vectors from
input data. The output can be returned as a matrix, with options to choose
between deep learning autoencoders or geometric transformations based on
the BLOSUM62 matrix.
}
\examples{
# Get Data
ibex_example <- get(data("ibex_example"))

# Using the encoder method with a variational autoencoder
ibex_values <- Ibex_matrix(ibex_example, 
                           chain = "Heavy",
                           method = "encoder",
                           encoder.model = "VAE",
                           encoder.input = "atchleyFactors")

# Using the geometric method with a specified angle
ibex_values <- Ibex_matrix(ibex_example, 
                           chain = "Heavy",
                           method = "geometric",
                           geometric.theta = pi)

}
\seealso{
\code{\link[immApex:sequenceEncoder]{immApex::propertyEncoder()}},
\code{\link[immApex:sequenceEncoder]{immApex::geometricEncoder()}}
}
