% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/LmWrapper.R, R/lmWrapper-glm.R
\docType{class}
\name{LMlike-class}
\alias{LMlike-class}
\alias{summary,LMlike-method}
\alias{update,LMlike-method}
\alias{waldTest,LMlike,CoefficientHypothesis-method}
\alias{waldTest,LMlike,matrix-method}
\alias{lrTest,LMlike,character-method}
\alias{lrTest,LMlike,CoefficientHypothesis-method}
\alias{lrTest,LMlike,Hypothesis-method}
\alias{lrTest,LMlike,matrix-method}
\alias{logLik,GLMlike-method}
\title{Linear Model-like Class}
\usage{
\S4method{summary}{LMlike}(object)

\S4method{update}{LMlike}(object, formula., design, keepDefaultCoef = FALSE, ...)

\S4method{waldTest}{LMlike,CoefficientHypothesis}(object, hypothesis)

\S4method{waldTest}{LMlike,matrix}(object, hypothesis)

\S4method{lrTest}{LMlike,character}(object, hypothesis)

\S4method{lrTest}{LMlike,CoefficientHypothesis}(object, hypothesis)

\S4method{lrTest}{LMlike,Hypothesis}(object, hypothesis)

\S4method{lrTest}{LMlike,matrix}(object, hypothesis)

\S4method{logLik}{GLMlike}(object)
}
\arguments{
\item{object}{\code{LMlike}}

\item{formula.}{\code{formula}}

\item{design}{something coercible to a \code{data.frame}}

\item{keepDefaultCoef}{\code{logical}. Should the coefficient names be preserved from \code{object} or updated if the model matrix has changed?}

\item{...}{passed to \code{model.matrix}}

\item{hypothesis}{one of a \code{CoefficientHypothesis}, \code{Hypothesis} or contrast \code{matrix}.}
}
\value{
see section "Methods (by generic)"
}
\description{
Wrapper around modeling function to make them behave enough alike that Wald tests and Likelihood ratio are easy to do.
To implement a new type of zero-inflated model, extend this class.
Depending on how different the method is, you will definitely need to override the \code{fit} method, and possibly the \code{model.matrix}, \code{model.matrix<-}, \code{update}, \code{coef}, \code{vcov}, and \code{logLik} methods.
}
\section{Methods (by generic)}{
\itemize{
\item \code{summary(LMlike)}: Print a summary of the coefficients in each component.

\item \code{update(LMlike)}: update the formula or design from which the \code{model.matrix} is constructed

\item \code{waldTest(object = LMlike, hypothesis = CoefficientHypothesis)}: Wald test dropping single term specified by \code{CoefficientHypothesis} \code{hypothesis}

\item \code{waldTest(object = LMlike, hypothesis = matrix)}: Wald test of contrast specified by contrast matrix \code{hypothesis}

\item \code{lrTest(object = LMlike, hypothesis = character)}: Likelihood ratio test dropping entire term specified by \code{character} \code{hypothesis} naming a term in the symbolic formula.

\item \code{lrTest(object = LMlike, hypothesis = CoefficientHypothesis)}: Likelihood ratio test dropping single term specified by \code{CoefficientHypothesis} \code{hypothesis}

\item \code{lrTest(object = LMlike, hypothesis = Hypothesis)}: Likelihood ratio test dropping single term specified by \code{Hypothesis} \code{hypothesis}

\item \code{lrTest(object = LMlike, hypothesis = matrix)}: Likelihood ratio test dropping single term specified by contrast matrix \code{hypothesis}

\item \code{logLik(GLMlike)}: return the log-likelihood of a fitted model

}}
\section{Slots}{

\describe{
\item{design}{a data.frame from which variables are taken for the right hand side of the regression}
\item{fitC}{The continuous fit}
\item{fitD}{The discrete fit}
\item{response}{The left hand side of the regression}
\item{fitted}{A \code{logical} with components "C" and "D", TRUE if the respective component has converged}
\item{formula}{A \code{formula} for the regression}
\item{fitArgsC}{}
\item{fitArgsD}{Both \code{list}s giving arguments that will be passed to the fitter (such as convergence criteria or case weights)}
}
}

\seealso{
coef

lrTest

waldTest

vcov

logLik
}
