% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supertest&frequencyplot.R
\name{computeFreqs}
\alias{computeFreqs}
\title{Compute Frequencies in a Named List}
\usage{
computeFreqs(elementsIntersections)
}
\arguments{
\item{elementsIntersections}{a named list}
}
\value{
a data.frame of the frequencies
}
\description{
Compute frequencies in a named list. This function is necessary for
\code{\link{plotFrequencies}}, in which it will calculate the frequency of
each pathway father for every omics intersection.
}
\examples{
omicsIntersection <- list(
    "exp;met" = c("PathwayA", "PathwayB", "PathwayC"),
    "exp;mut" = c("PathwayA", "PathwayC"),
    "cnv;mut" = c("PathwayB")
)
freqDf <- computeFreqs(omicsIntersection)

}
