% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{makeOmics}
\alias{makeOmics}
\title{Omics class initializer function}
\usage{
makeOmics(
  experiments = ExperimentList(),
  colData = S4Vectors::DataFrame(),
  sampleMap = S4Vectors::DataFrame(assay = factor(), primary = character(), colname =
    character()),
  metadata = list(),
  drops = list(),
  modelInfo = character(),
  specificArgs = list()
)
}
\arguments{
\item{experiments}{A \code{list} or \link{ExperimentList} of all
combined experiments}

\item{colData}{A \code{\linkS4class{DataFrame}} or \code{data.frame} of
characteristics for all biological units}

\item{sampleMap}{A \code{DataFrame} or \code{data.frame} of assay names,
sample identifiers, and colname samples}

\item{metadata}{An optional argument of 'ANY' class (usually list) for
content describing the experiments}

\item{drops}{A \code{list} of unmatched information
(included after subsetting)}

\item{modelInfo}{A list with length equal to length(data) that are modelInfo
to process each dataset}

\item{specificArgs}{a list with length equal to length(data) to set
additional parameters specific of the modelInfo}
}
\value{
an \code{Omics} class object
}
\description{
makeOmics creates the \code{Omics} object necessary to perform most of the
analyses of this package. It contains all the omics data in the format of a
\code{ExperimentList}, the clinical data, and all the information necessary for
the dimensionality reduction step.
}
\examples{
data(ovarianDataset)

myColData <- data.frame(
    status = sample(c(0, 1), 50, replace = TRUE),
    days = sample(c(0, 500), 50, replace = TRUE),
    row.names = colnames(ovarianDataset$exp)
)

myOmicsObj <- makeOmics(
    experiments = ovarianDataset,
    colData = myColData,
    modelInfo = c(
        "summarizeWithPca",
        "summarizeInCluster",
        "summarizeToNumberOfEvents",
        "summarizeToNumberOfDirectionalEvents"
    ),
    specificArgs = list(
        pcaArgs = list(
            name = "exp", shrink = "FALSE",
            method = "sparse", maxPCs = 3
        ),
        clusterArgs = list(
            name = "met",
            max_cluster_number = 3
        ),
        countEvent = list(name = "mut", min_prop = 0.05),
        cnvAgv = list(name = "cnv", min_prop = 0.05)
    )
)

}
