% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supertest&frequencyplot.R
\name{plotFrequencies}
\alias{plotFrequencies}
\title{Plot Frequencies of Pathway Fathers for Omics intersection}
\usage{
plotFrequencies(
  frequencies,
  manualColors = NULL,
  minSize = 4,
  maxSize = 20,
  width = 20,
  relMagnificationOfLegend = 0.5,
  lineSize = 1
)
}
\arguments{
\item{frequencies}{a data.frame created from 'computeFreqs'}

\item{manualColors}{optional vector of colors to be used}

\item{minSize}{the minimal font size. Maximal frequencies will be added for
each class}

\item{maxSize}{the maximal font size dimension, all values above are clipped}

\item{width}{the number of character to wrap the labels}

\item{relMagnificationOfLegend}{the relative magnification of the text of the
legend}

\item{lineSize}{the thickness of the lines}
}
\value{
a circular plot of the frequencies of pathway fathers
}
\description{
Plots the frequencies of the pathway fathers by every omics intersection
from a data.frame of the frequencies returned with the function
\code{\link{computeFreqs}}.
}
\examples{
df <- data.frame(
    category = c("PathwayA", "PathwayB", "PathwayC", "PathwayD"),
    frequencies = c(1, 2, 1, 3),
    class = rep("Mut", 4), stringsAsFactors = FALSE
)
plotFrequencies(df)

}
