% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualize_Isotonic_Fit.R
\name{plotIsotonic}
\alias{plotIsotonic}
\title{Plot Isotonic Regression Model}
\usage{
plotIsotonic(
  fit,
  ratio = TRUE,
  show_ic50 = FALSE,
  drug_name = NULL,
  protein_name = NULL,
  x_lab = expression(Log[10] ~ "[drug (M)]"),
  y_lab = "Log2 Intensity",
  title = NULL,
  ci = NULL,
  legend = FALSE,
  theme_style = "classic",
  original_label = FALSE
)
}
\arguments{
\item{fit}{A model object returned by fitIsotonicRegression().}

\item{ratio}{Logical. If TRUE, shows plot on the ratio scale relative to DMSO (i.e. 0-1 scale). Default is FALSE.}

\item{show_ic50}{Logical. If TRUE, adds vertical line and annotation for IC50.}

\item{drug_name}{Drug name for plotting data.}

\item{protein_name}{Protein name for plot.}

\item{x_lab}{Label for x-axis.}

\item{y_lab}{Label for y-axis.}

\item{title}{Title for the plot.}

\item{ci}{Logical. Include IC50 95\% confidence interval bands if TRUE. Default is FALSE.}

\item{legend}{Logical. Show legend if TRUE.}

\item{theme_style}{ggplot2 theme name to apply (default = "classic").}

\item{original_label}{Logical. If TRUE, replace x-axis tick labels with original dose labels.}
}
\value{
A ggplot object.
}
\description{
Plot Isotonic Regression Model
}
