% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_logs.R
\name{parse_logs}
\alias{parse_logs}
\title{Parse data from log files}
\usage{
parse_logs(
  save_dir = getwd(),
  pattern = "MungeSumstats_log_msg.txt$",
  verbose = TRUE
)
}
\arguments{
\item{save_dir}{Top-level directory to recursively search
for log files within.}

\item{pattern}{Regex pattern to search for files with.}

\item{verbose}{Print messages.}
}
\value{
\link[data.table]{data.table} of parsed log data.
}
\description{
Parses data from the log files generated by
\link[MungeSumstats]{format_sumstats} or
\link[MungeSumstats]{import_sumstats} when the argument
\code{log_mungesumstats_msgs} is set to \code{TRUE}.
}
\examples{
save_dir <- system.file("extdata",package = "MungeSumstats")
log_data <- MungeSumstats::parse_logs(save_dir = save_dir)
}
