% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logs_example.R
\name{logs_example}
\alias{logs_example}
\title{Example logs file}
\source{
\code{
eduAttainOkbayPth <- system.file("extdata", "eduAttainOkbay.txt",
                                 package = "MungeSumstats")
sumstats_dt <- data.table::fread(eduAttainOkbayPth)
#### Introduce values that need to be fixed ####
sumstats_dt$Pval[10:15] <- 5
sumstats_dt$Pval[20:22] <- -5
sumstats_dt$Pval[23:25] <- "5e-324"
ss_path <- tempfile()
data.table::fwrite(sumstats_dt, ss_path)
log_folder <- tempdir()
reformatted <- MungeSumstats::format_sumstats(
    path = ss_path,
    ref_genome = "GRCh37",
    log_folder = log_folder,
    log_mungesumstats_msgs = TRUE,
    log_folder_ind = TRUE,
)
file.copy(reformatted$log_files$MungeSumstats_log_msg,
          "inst/extdata",overwrite = TRUE)
}
}
\usage{
logs_example(read = FALSE)
}
\arguments{
\item{read}{Whether to read the logs file into memory.}
}
\value{
Path to logs file.
}
\description{
Example logs file produced by \link[MungeSumstats]{format_sumstats}.
}
\keyword{internal}
