% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolBox.R
\name{mIntersect}
\alias{mIntersect}
\alias{mUnion}
\title{Multi-intersection, union}
\usage{
mIntersect(x, y, ...)
mUnion(x, y, ...)
}
\arguments{
\item{x, y, ...}{objects to find intersection/union.}
}
\value{
An intersection/union of input parameters
}
\description{
A recusive loop for intersecting multiple sets.
}
\examples{

data('phospho_liverInsTC_RUV_sample')
data('phospho_L6_ratio')

site1 <- gsub('~[STY]', ';',
            sapply(strsplit(rownames(phospho.L6.ratio), ';'),
                    function(x){paste(toupper(x[2]), x[3], sep=';')}))
site2 <- rownames(phospho.liver.Ins.TC.ratio.RUV)

# step 2: rank by fold changes
treatment.grps = split(seq(ncol(phospho.L6.ratio)), 
    gsub('_exp\\\\d+', '', colnames(phospho.L6.ratio)))
tmp <- do.call(
    cbind, 
    lapply(treatment.grps, function(i){
        rowMeans(phospho.L6.ratio[,i])
    })
)
site1 <- t(sapply(split(data.frame(tmp), site1), colMeans))[,-1]

treatment.grps = split(
    seq(ncol(phospho.liver.Ins.TC.ratio.RUV)),
    gsub('(Intensity\\\\.)(.*)(\\\\_Bio\\\\d+)', '\\\\2', 
        colnames(phospho.liver.Ins.TC.ratio.RUV)
    )
)
tmp <- do.call(
    cbind, 
    lapply(
        treatment.grps,
        function(i){
            rowMeans(phospho.liver.Ins.TC.ratio.RUV[,i])
        }
    )
)
site2 <- t(sapply(split(data.frame(tmp), site2), colMeans))

o <- mIntersect(site1, site2)

}
