% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeDistribution.R
\name{createVariableDistributionDataSubset}
\alias{createVariableDistributionDataSubset}
\title{Create data for additional variable distribution (for a subset data)}
\usage{
createVariableDistributionDataSubset(fullProfileData,
    distributionData, selectedGenes, selectedTaxa)
}
\arguments{
\item{fullProfileData}{dataframe contains the full processed profiles (see
?fullProcessedProfile, ?filterProfileData or ?fromInputToProfile)}

\item{distributionData}{dataframe contains the full distribution data (see
?createVariableDistributionData)}

\item{selectedGenes}{list of genes of interest. Default = "all".}

\item{selectedTaxa}{list of taxa of interest Default = "all".}
}
\value{
A dataframe for analysing the distribution of the additional
variable(s) for a subset of genes and/or taxa containing the protein
(ortholog) IDs and the values of their variables (var1 and var2).
}
\description{
Create data for additional variable distribution (for a subset data)
}
\examples{
data("fullProcessedProfile", package="PhyloProfile")
data("mainLongRaw", package="PhyloProfile")
distributionData <- createVariableDistributionData(
    mainLongRaw, c(0, 1), c(0.5, 1)
)
selectedGenes <- "100136at6656"
selectedTaxa <- c("Mammalia", "Saccharomycetes", "Insecta")
createVariableDistributionDataSubset(
    fullProcessedProfile,
    distributionData,
    selectedGenes,
    selectedTaxa
)
}
\seealso{
\code{\link{parseInfoProfile}},
\code{\link{createVariableDistributionData}},
\code{\link{fullProcessedProfile}}, \code{\link{mainLongRaw}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
