% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDomainPlot.R
\name{singleDomainPlotting}
\alias{singleDomainPlotting}
\title{Create architecure plot for a single protein}
\usage{
singleDomainPlotting(df, geneID, sep, labelSize, titleSize, minStart,
    maxEnd, colorPalette, showScore, showWeight, namePosition, firstDist,
    nameType, nameSize, segmentSize, nameColor, labelPos, font)
}
\arguments{
\item{df}{Domain dataframe for ploting containing the seed ID, ortholog ID,
ortholog sequence length, feature names, start and end positions,
feature weights (optional) and the status to determine if that feature is
important for comparison the architecture between 2 proteins* (e.g. seed
protein vs ortholog) (optional)}

\item{geneID}{ID of seed or orthologous protein}

\item{sep}{Separate indicator for title. Default = "|"}

\item{labelSize}{Lable size. Default = 12}

\item{titleSize}{Title size. Default = 12}

\item{minStart}{The smallest start position of all domains}

\item{maxEnd}{The highest stop position of all domains}

\item{colorPalette}{Color pallete. Default = Paired"}

\item{showScore}{Show/hide E-values and Bit-scores. Default = NULL (hide)}

\item{showWeight}{Show/hide feature weights. Default = NULL (hide)}

\item{namePosition}{List of positions for domain names, choose from "plot",
"legend" or "axis". Default: "plot"}

\item{firstDist}{Distance of the first domain to plot title. Default = 0.5}

\item{nameType}{Type of domain names, either "Texts" or "Labels" (default)}

\item{nameSize}{Size of domain names. Default = 3}

\item{segmentSize}{Height of domain segment. Default = 5}

\item{nameColor}{Color of domain names (for Texts only). Default = "black"}

\item{labelPos}{Position of domain names (for Labels only). Choose from
"Above" (default), "Below" or "Inside" the domain bar}

\item{font}{font of text. Default = Arial"}
}
\value{
Domain plot of a single protein as a ggplot object.
}
\description{
Create architecure plot for a single protein
}
\examples{
seed <- "101621at6656"
ortho <- "101621at6656|AGRPL@224129@0|224129_0:001955|1"
ortho <- gsub("\\\\|", ":", ortho)
grepID <- paste(seed, "#", ortho, sep = "")
domainFile <- system.file(
    "extdata", "domainFiles/101621at6656.domains",
    package = "PhyloProfile", mustWork = TRUE
)
domainDf <- parseDomainInput(seed, domainFile, "file")
domainDf$feature_id_mod <- domainDf$feature_id
subdomainDf <- domainDf[grep(grepID, domainDf$seedID), ]
subdomainDf$feature <- as.character(subdomainDf$feature)
orthoDf <- subdomainDf[subdomainDf$orthoID == ortho,]
seedDf <- subdomainDf[subdomainDf$orthoID != ortho,]
minStart <- min(subdomainDf$start)
maxEnd <- max(c(subdomainDf$end, subdomainDf$length))
# resolve overlapping domains
seedDf <- PhyloProfile:::resolveOverlapFeatures(seedDf)
orthoDf <- PhyloProfile:::resolveOverlapFeatures(orthoDf)
# add feature colors
featureColorDf <- PhyloProfile:::addFeatureColors(seedDf, orthoDf)
seedDf <- featureColorDf[[1]]
orthoDf <- featureColorDf[[2]]
# do plot
g <- PhyloProfile:::singleDomainPlotting(
   seedDf, seed, minStart = minStart, maxEnd = maxEnd, font = "sans"
)
grid::grid.draw(g)
}
\seealso{
\code{\link{parseDomainInput}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
