% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/associations.estimation.R
\name{associationAlterations}
\alias{associationAlterations}
\title{associationAlterations}
\usage{
associationAlterations(alterations, signatures)
}
\arguments{
\item{alterations}{Matrix with the observed mutations (columns) for each patient (rows) as binary variables.}

\item{signatures}{Matrix with the estimated exposures to signatures (columns) for each patient (rows).}
}
\value{
A list with the association estimates. It includes 5 elements:
             alterations: matrix with the observed mutations (columns) for each patient (rows) as binary variables.
             signatures: matrix with the estimated exposures to signatures (columns) for each patient (rows).
             associations: estimated associations.
             intercept: intercept resulting from the regularized regression estimate.
             fold_changes: fold changes estimating the strength of the associations.
}
\description{
Perform the estimation of the mutations associated to specific mutational signatures.
}
\examples{
data(association_mutations)
set.seed(12345)
alterations = association_mutations$alterations
normalized_alpha = association_mutations$normalized_alpha
association_alterations = associationAlterations(alterations = alterations, signatures = normalized_alpha)

}
