% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modifier-RiboMethSeq-class.R
\docType{class}
\name{ModRiboMethSeq}
\alias{ModRiboMethSeq}
\alias{RiboMethSeq}
\alias{ModSetRiboMethSeq}
\alias{ModRiboMethSeq-class}
\alias{ModSetRiboMethSeq-class}
\title{ModRiboMethSeq class to analyze RiboMethSeq data}
\usage{
ModRiboMethSeq(x, annotation = NA, sequences = NA, seqinfo = NA, ...)

ModSetRiboMethSeq(x, annotation = NA, sequences = NA, seqinfo = NA, ...)
}
\arguments{
\item{x}{the input which can be of the different types depending on whether
a \code{ModRiboMethSeq} or a \code{ModSetRiboMethSeq} object is to be 
constructed. For more information have a look at the documentation of
the \code{\link[RNAmodR:Modifier-class]{Modifier}} and 
\code{\link[RNAmodR:ModifierSet-class]{ModifierSet}} classes.}

\item{annotation}{annotation data, which must match the information contained
in the BAM files. This is parameter is only required if \code{x} if not a 
\code{Modifier} object.}

\item{sequences}{sequences matching the target sequences the reads were 
mapped onto. This must match the information contained in the BAM files. This
is parameter is only required if \code{x} if not a \code{Modifier} object.}

\item{seqinfo}{An optional \code{\link[Seqinfo:Seqinfo-class]{Seqinfo}} 
argument or character vector, which can be coerced to one, to subset the 
sequences to be analyzed on a per chromosome basis.}

\item{...}{Optional arguments overwriting default values, which are
\itemize{
\item weights: The weights used for calculating the scores B and RMS 
(default: \code{weights = c(0.9,1,0,1,0.9)}).
\item flankingRegion: The size of the flanking region used for calculation 
of score A as an integer value (default: \code{flankingRegion = 6L}).
\item minSignal: The minimal signal at the position as integer value 
(default: \code{minSignal = 10L}). If the reaction is very specific a lower
value and even 0L may need to be used.
\item minScoreA: minimum for score A to identify 2'-O methylated positions 
de novo (default: \code{minScoreA = 0.6}).
\item minScoreB: minimum for score B to identify 2'-O methylated positions 
de novo (default: \code{minScoreB = 3.0}).
\item minScoreRMS: minimum for score RMS to identify 2'-O methylated 
positions de novo (default: \code{minScoreRMS = 0.75}).
\item minScoreMean: minimum for ScoreMean to identify 2'-O methylated 
positions de novo (default: \code{minScoreMean = 0.75}).
\item flankingRegionMean: The size of the flanking region used for 
calculation of ScoreMean as an integer value (default: 
\code{flankingRegionMean = 2L}).
\item scoreOperator: how the minimal score should be used as logical 
operator. "&" requires all minimal values to be exceeded, whereas "|" detects
positions, if at least one minimal values is exceeded (default: 
\code{scoreOperator = "&"}).
\item maxLength: The default read length. Reads with this length or longer
are discarded, since they represent non-fragmented reads. This might need to
be adjusted for individual samples depending on the experimental conditions.
This is argument is passed on to 
\code{\link[RNAmodR:ProtectedEndSequenceData-class]{ProtectedEndSequenceData}}
(default: \code{maxLength = 50L}).
\item other arguments which are passed on to 
\code{\link[RNAmodR:ProtectedEndSequenceData-class]{ProtectedEndSequenceData}}.
}
To disable minimal values for modification calling, set them to \code{0}.
It is not advised to set them all to \code{0}.}
}
\value{
a \code{ModRiboMethSeq} or \code{ModSetRiboMethSeq} object
}
\description{
Among the various post-transcriptional RNA modifications, 2'-O methylations
are quite common in rRNA and tRNA. They confere resistance to alkaline 
degradation by preventing a nucleophilic attack on the 3'-phosphate 
especially in flexible RNA, which is fascilitated by high pH conditions.
This property can be queried using a method called RiboMethSeq (Birkedahl et 
al. 2015, Marchand et al. 2017) for which RNA is treated in alkaline 
conditions and RNA fragments are used to prepare a sequencing library.

At position containing a 2'-O methylations, read ends are less frequent, 
which is used to detect and score the2'-O methylations.

\code{dataType} is \code{"ProtectedEndSequenceData"}:

The \code{ModRiboMethSeq} class uses the the 
\code{\link[RNAmodR:ProtectedEndSequenceData-class]{ProtectedEndSequenceData}}
class to store and aggregate data along the transcripts. The calculated 
scores follow the nomenclature of Birkedahl et al. (2015) with the names
\code{scoreRMS} (default), \code{scoreA}, \code{scoreB} and \code{scoreMean}.

The ScoreMax as described by Marchand et al. (2017) are not implemented, 
yet, since an unambigeous description is not available from the literature.

The ScoreMean as described by Galvanin et al. (2018) is implemented. However,
use with caution, since the description is not unambigeous. Currently it is
calculated as as: 1 - (n / mean(areaL + areaR)). (n: counts at position, 
areaL: counts from x position upstream, areaR: counts from x position 
downstream)

Only samples named \code{treated} are used for this analysis. Normalization 
to untreated samples is currently not used.

The \code{ModRiboMethSeq5} class can be used as well. However, as 
\code{SequenceData} the 
\code{\link[RNAmodR:EndSequenceData-class]{End5SequenceData}} is employed using
only the 5'-end positions of reads.
}
\examples{
library(RNAmodR.Data)
library(rtracklayer)
annotation <- GFF3File(RNAmodR.Data.example.RMS.gff3())
sequences <- RNAmodR.Data.example.RMS.fasta()
files <- list("Sample1" = c(treated = RNAmodR.Data.example.RMS.1()),
              "Sample2" = c(treated = RNAmodR.Data.example.RMS.1()))
# Creating a Modifier object of type ModRiboMethSeq
mrms <- ModRiboMethSeq(files[[1]], annotation = annotation, sequences = sequences)
# Creating a ModifierSet object of type ModSetRiboMethSeq
msrms <- ModSetRiboMethSeq(files, annotation = annotation, sequences = sequences)
}
\references{
- Birkedal U, Christensen-Dalsgaard M, Krogh N, Sabarinathan R, Gorodkin J, 
Nielsen H (2015): "Profiling of ribose methylations in RNA by high-throughput
sequencing." Angewandte Chemie (International ed. in English) 54 (2), 
P. 451–455. DOI: 
\href{https://doi.org/10.1002/anie.201408362}{10.1002/anie.201408362}.

- Marchand V, Ayadi L, El Hajj A, Blanloeil-Oillo F, Helm M, Motorin Y 
(2017): "High-Throughput Mapping of 2'-O-Me Residues in RNA Using 
Next-Generation Sequencing (Illumina RiboMethSeq Protocol)." Methods in 
molecular biology (Clifton, N.J.) 1562, P. 171–187. DOI: 
\href{https://doi.org/10.1007/978-1-4939-6807-7_12}{10.1007/978-1-4939-6807-7_12}.

- Galvanin A, Ayadi L, Helm M, Motorin Y, Marchand V (2017): "Mapping and 
Quantification of tRNA 2'-O-Methylation by RiboMethSeq". Wajapeyee N., Gupta
R. (eds) Epitranscriptomics. Methods in Molecular Biology (Humana Press, 
New York, NY) 1870, P. 273-295. DOI: 
\href{https://doi.org/10.1007/978-1-4939-8808-2_21}{10.1007/978-1-4939-8808-2_21}
}
\author{
Felix G.M. Ernst [aut]
}
