% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceData-protected-end-pos.R
\docType{class}
\name{ProtectedEndSequenceData-class}
\alias{ProtectedEndSequenceData-class}
\alias{ProtectedEndSequenceData}
\alias{ProtectedEndSequenceDataFrame-class}
\alias{ProtectedEndSequenceDataFrame}
\alias{getData,ProtectedEndSequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam-method}
\alias{aggregateData,ProtectedEndSequenceData-method}
\alias{getDataTrack,ProtectedEndSequenceData-method}
\title{ProtectedEndSequenceData}
\usage{
ProtectedEndSequenceDataFrame(
  df,
  ranges,
  sequence,
  replicate,
  condition,
  bamfiles,
  seqinfo
)

ProtectedEndSequenceData(bamfiles, annotation, sequences, seqinfo, ...)

\S4method{getData}{ProtectedEndSequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam}(x, bamfiles, grl, sequences, param, args)

\S4method{aggregateData}{ProtectedEndSequenceData}(x, condition = c("Both", "Treated", "Control"))

\S4method{getDataTrack}{ProtectedEndSequenceData}(x, name, ...)
}
\arguments{
\item{df, ranges, sequence, replicate}{inputs for creating a 
\code{SequenceDataFrame}. See 
\code{\link[=SequenceDataFrame-class]{SequenceDataFrame}}.}

\item{condition}{For \code{\link{aggregate}}: condition for which the data 
should be aggregated.}

\item{bamfiles, annotation, seqinfo, grl, sequences, param, args, ...}{See 
\code{\link[=SequenceData-class]{SequenceData}} and
\code{\link[=SequenceData-functions]{SequenceData-functions}}}

\item{x}{a \code{ProtectedEndSequenceData}}

\item{name}{For \code{\link[=plotDataByCoord]{getDataTrack}}: a valid 
transcript name. Must be a name of \code{ranges(x)}}
}
\value{
a \code{ProtectedEndSequenceData} object
}
\description{
\code{ProtectedEndSequenceData} implements
\code{\link[=SequenceData-class]{SequenceData}} to contain and aggregate the
start and ends of reads per position along a transcript.
\code{ProtectedEndSequenceData} offsets the start position by -1 to align the
information on the 5'-3'-phosphate bonds to one position. The
\code{ProtectedEndSequenceData} class is implemented specifically as required
for the \code{RiboMethSeq} method.

The objects of type \code{ProtectedEndSequenceData} contain three columns per
data file named using the following naming convention
\code{protectedend.condition.replicate}.

\code{aggregate} calculates the mean and sd for samples in the \code{control}
and \code{treated} condition separatly.
}
\examples{
# Construction of a ProtectedEndSequenceData object
library(RNAmodR.Data)
library(rtracklayer)
annotation <- GFF3File(RNAmodR.Data.example.man.gff3())
sequences <- RNAmodR.Data.example.man.fasta()
files <- c(treated = RNAmodR.Data.example.wt.1())
pesd <- ProtectedEndSequenceData(files, annotation = annotation,
                                 sequences = sequences)
}
