% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTCGAToolbox-Class.R
\name{getData}
\alias{getData}
\title{Extract data from FirehoseData object}
\usage{
getData(object, type, platform)
}
\arguments{
\item{object}{A \linkS4class{FirehoseData} object}

\item{type}{A data type to be extracted}

\item{platform}{An index for data types that may come from multiple
platforms (such as mRNAArray), for GISTIC data, one of the options:
'AllByGene' or 'ThresholdedByGene'}
}
\value{
Returns matrix or data.frame depending on data type
}
\description{
A go-to function for getting top level information from a
\linkS4class{FirehoseData} object. Available datatypes for a
particular object can be seen by entering the object name in the
console ('show' method).
}
\examples{
data(accmini)
getData(accmini, "clinical")
getData(accmini, "RNASeq2GeneNorm")
getData(accmini, "Methylation", 1)[1:4]

}
