% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCrossRegionalDE_withProp.R
\name{GetCrossRegionalDE_withProp}
\alias{GetCrossRegionalDE_withProp}
\title{Identify cross-regional differential analysis with proportion}
\usage{
GetCrossRegionalDE_withProp(
  sce,
  twoCenter = c(3, 4),
  label = "celltype",
  n_markers = 10,
  angle = 30,
  hjust = 0,
  size = 3,
  padj_filter = 0.05,
  doHeatmap = TRUE
)
}
\arguments{
\item{sce}{A single cell experiment object.}

\item{twoCenter}{A vector of two numbers for the interested ROI numbers.}

\item{label}{A variable name that contains the cell type information.}

\item{n_markers}{A number specifying the top DE gene number.}

\item{angle}{A number for angle when plotting.}

\item{hjust}{A number for horizontal justification when plotting.}

\item{size}{A number for text font size.}

\item{padj_filter}{A number for filtering adjusted p values.}

\item{doHeatmap}{Logical variable for whether drawing the heatmap.}
}
\value{
A list including the top DE genes (topDE), and all DE genes (allDE).
}
\description{
Identify cross-regional differential analysis with proportion
}
\examples{
data("example_sce")
example_sce <- mySpatialPreprocess(example_sce, platform="Visium")
# Since the example data is very small, I set padj filter as NULL. Default is 0.05.
GetCrossRegionalDE_withProp(example_sce, twoCenter = c(1,2), padj_filter = NULL)

}
