% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindRegionalCells.R
\name{FindRegionalCells}
\alias{FindRegionalCells}
\title{Identify regional cells given centers and radiuses}
\usage{
FindRegionalCells(
  sce,
  centerID,
  enhanced = FALSE,
  radius = 10,
  avern = 5,
  doPlot = FALSE,
  returnPlot = FALSE
)
}
\arguments{
\item{sce}{A single cell experiment object.}

\item{centerID}{One or a vector of spot IDs as centers of ROIs.}

\item{enhanced}{A logical variable for plotting enhanced plot or now. Default is FALSE.}

\item{radius}{A number of fixed ROI radius.}

\item{avern}{A number of the average sites used to compute unit distance, default is 5.}

\item{doPlot}{A logical variable to specify whether plot the figure or not.}

\item{returnPlot}{a logical variable to specify whether output the plot or not.}
}
\value{
A list including center spot ID and regional spot IDs.
}
\description{
Identify regional cells given centers and radiuses
}
\examples{
# FindRegionalCells(sce, centerID = "ACGCCTGACACGCGCT-1")

}
