% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{SGFeatures}
\alias{SGFeatures}
\title{Splice graph features}
\usage{
SGFeatures(x, type = mcols(x)$type, splice5p = mcols(x)$splice5p,
  splice3p = mcols(x)$splice3p, featureID = mcols(x)$featureID,
  geneID = mcols(x)$geneID, txName = mcols(x)$txName,
  geneName = mcols(x)$geneName)
}
\arguments{
\item{x}{\code{GRanges} with known strand (\dQuote{+}, \dQuote{-})}

\item{type}{Character vector or factor taking value \code{J},
\code{E}, \code{D}, or \code{A}}

\item{splice5p}{Logical vector indicating a mandatory splice at the
5' end of an exon bin (determining whether reads extending across
the 5' boundary must be spliced to be considered compatible)}

\item{splice3p}{Logical vector indicating a mandatory splice at the
3' end of an exon bin (determining whether reads extending across
the 3' boundary must be spliced to be considered compatible)}

\item{featureID}{Integer vector of feature IDs}

\item{geneID}{Integer vector of gene IDs}

\item{txName}{\code{CharacterList} of transcript names or \code{NULL}}

\item{geneName}{\code{CharacterList} of gene names or \code{NULL}}
}
\value{
\code{SGFeatures} object
}
\description{
Creates an instance of S4 class \code{SGFeatures} for storing
splice graph features.
}
\details{
\code{SGFeatures} extends \code{GRanges} with column slot \code{type}
specifying feature type. \code{type} is a factor with levels
\code{J} (splice junction), \code{E} (exon bin),
\code{D} (splice donor), \code{A} (splice acceptor).

\code{splice5p} and \code{splice3p} are logical vectors indicating
mandatory splices at the 5' and 3' end of an exon bin, respectively.
These are used to determine whether reads extending across the
5' and 3' boundaries of an exon bin must be spliced at the boundary
to be considered compatible with the exon bin.

\code{featureID} and \code{geneID} are integer vectors representing
unique identifiers for features and genes (connected components in
the splice graph).

\code{txName} and \code{geneName} are CharacterLists storing
transcript and gene annotation, respectively.
}
\examples{
sgf <- SGFeatures()
}
\author{
Leonard Goldstein
}
