% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convertToTxFeatures}
\alias{convertToTxFeatures}
\title{Convert to TxFeatures object}
\usage{
convertToTxFeatures(x)
}
\arguments{
\item{x}{\code{TxDb} object or \code{GRangesList} of exons grouped
by transcript. For import from GFF format, use function
\code{importTranscripts}.}
}
\value{
\code{TxFeatures} object
}
\description{
Convert a \code{TxDb} object or a \code{GRangesList} of exons
grouped by transcripts to a \code{TxFeatures} object.
}
\details{
If \code{x} is a \code{GRangesList}, transcript names and gene names
can be specified as character vectors in metadata
columns \code{txName} and \code{geneName}, respectively.
If missing, transcript names are based on \code{names(x)}.
For import from GFF format, use function \code{importTranscripts}.

In the returned \code{TxFeatures} object, column \code{type} takes
values \dQuote{J} (splice junction), \dQuote{I} (internal exon),
\dQuote{F} (5'/first exon), \dQuote{L} (3'/last exon) or \dQuote{U}
(unspliced).
}
\examples{
gr <- GRanges(c(1, 1), IRanges(c(1, 201), c(100, 300)), c("+", "+"))
grl <- split(gr, 1)
txf <- convertToTxFeatures(grl)
}
\author{
Leonard Goldstein
}
