% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotVariants}
\alias{plotVariants}
\title{Plot splice graph and heatmap of splice variant frequencies}
\usage{
plotVariants(x, eventID = NULL, tx_view = FALSE, cex = 1,
  transform = function(x) {     x }, Rowv = NULL, distfun = dist,
  hclustfun = hclust, margin = 0.2, RowSideColors = NULL,
  square = FALSE, cexRow = 1, cexCol = 1, labRow = colnames(x),
  col = colorRampPalette(c("black", "gold"))(256), zlim = c(0, 1),
  heightPanels = c(1, 2), expand_variants = FALSE, ...)
}
\arguments{
\item{x}{\code{SGVariantCounts} object}

\item{eventID}{Single event identifier used to subset \code{x}}

\item{tx_view}{Plot transcripts instead of splice graph (experimental)}

\item{cex}{Scale parameter for feature labels and annotation}

\item{transform}{Transformation applied to splice variant frequencies}

\item{Rowv}{Determines order of rows. Either a vector of values used to
reorder rows, or \code{NA} to suppress reordering, or \code{NULL} for
hierarchical clustering.}

\item{distfun}{Distance function used for hierarchical clustering
of rows (samples)}

\item{hclustfun}{Clustering function used for hierarchical clustering
of rows (samples)}

\item{margin}{Width of right-hand margin as fraction of width of the
graphics device. Ignored if \code{square} is \code{TRUE}.}

\item{RowSideColors}{Character vector (or list of character vectors)
with length(s) equal to \code{ncol(x)} containing color names for
horizontal side bars for sample annotation}

\item{square}{Logical, if \code{TRUE} margins are set such that
cells in the heatmap are square}

\item{cexRow}{Scale factor for row (sample) labels}

\item{cexCol}{Scale factor for column (feature) labels}

\item{labRow}{Character vector of row (sample) labels}

\item{col}{Heatmap colors}

\item{zlim}{Range of values for which colors should be plotted,
if \code{NULL} range of finite values}

\item{heightPanels}{Numeric vector of length two indicating height of
the top and bottom panels.}

\item{expand_variants}{Experimental option - leave set to \code{FALSE}}

\item{...}{further arguments passed to \code{plotSpliceGraph}}
}
\value{
\code{data.frame} with information on exon bins and
  splice junctions included in the splice graph
}
\description{
Plot splice graph and heatmap of splice variant frequencies.
}
\examples{
\dontrun{
sgvc_annotated <- annotate(sgvc_pred, txf_ann)
plotVariants(sgvc_annotated)
}
NULL
}
\author{
Leonard Goldstein
}
