% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-prediction.R
\name{predictSpliced}
\alias{predictSpliced}
\title{Ranges-based identification of splice junctions and exons}
\usage{
predictSpliced(frag_exonic, frag_intron, min_junction_count, psi, beta, gamma,
  min_anchor, include_counts, retain_coverage, junctions_only, max_complexity,
  sample_name, seqlevel, strand)
}
\arguments{
\item{frag_exonic}{\code{IRangesList} with exonic regions from alignments}

\item{frag_intron}{\code{IRangesList} with introns implied by spliced
alignments}

\item{min_junction_count}{Minimum fragment count required for a splice
junction to be included. If specified, argument \code{alpha} is ignored.}

\item{psi}{Minimum splice frequency required for a splice junction
to be included}

\item{beta}{Minimum relative coverage required for an internal exon
to be included}

\item{gamma}{Minimum relative coverage required for a terminal exon
to be included}

\item{min_anchor}{Integer specifiying minimum anchor length}

\item{include_counts}{Logical indicating whether counts of
compatible fragments should be included in metadata column
\dQuote{N}}

\item{retain_coverage}{Logical indicating whether coverage for each
exon should be retained as an \code{RleList} in metadata
column \dQuote{coverage}. This allows filtering of features
using more stringent criteria after the initial prediction.}

\item{junctions_only}{Logical indicating whether predictions
should be limited to identification of splice junctions only}

\item{max_complexity}{Maximum allowed complexity. If a locus exceeds
this threshold, it is skipped, resulting in a warning.
Complexity is defined as the maximum number of unique predicted
splice junctions overlapping a given position.
High complexity regions are often due to spurious read alignments
and can slow down processing. To disable this filter, set to \code{NA}.}

\item{sample_name}{Sample name used in messages}

\item{seqlevel}{\code{seqlevel} to be processed}

\item{strand}{\code{strand} to be processed}
}
\value{
\code{IRanges} with predicted features
}
\description{
Ranges-based identification of splice junctions and exons.
}
\author{
Leonard Goldstein
}
\keyword{internal}
