% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequences.R
\name{predictVariantEffects}
\alias{predictVariantEffects}
\title{Predict the effect of splice variants on protein-coding transcripts}
\usage{
predictVariantEffects(sgv, tx, genome, fix_start_codon = TRUE,
  output = c("short", "full"), cores = 1)
}
\arguments{
\item{sgv}{\code{SGVariants} object}

\item{tx}{\code{TxDb} object, or \code{GRangesList} of exons
grouped by transcript with metadata columns \code{txName},
\code{geneName}, \code{cdsStart} and \code{cdsEnd}
(by convention, cdsStart < cdsEnd for both strands).
For import from GFF format, use function \code{importTranscripts}.}

\item{genome}{\code{BSgenome} object}

\item{fix_start_codon}{Logical indicating whether the annotated start
codon should be considered fixed and the variant transcript should
not be scanned for alternative start codons}

\item{output}{Character string indicating whether short results or
full results (with additional columns) should be returned}

\item{cores}{Number of cores available for parallel processing}
}
\value{
\code{data.frame} with rows corresponding to a
  variant-transcript pair. The output includes columns for variant
  identifier, transcript name, gene name, type of alteration at the
  RNA and protein level, and variant description at the RNA and
  protein level in HGVS notation. For \code{output = "full"}
  additional columns are returned. These include the full-length RNA
  and protein sequence for the reference and variant transcript.
  Event start and end coordinates in the full output are 0- and
  1-based, respectively (to allow for description of deletions).
  Coordinates for the last junction in a transcript refer to the
  last base of the second-to-last exon.
}
\description{
The effect of a splice variant is predicted for individual
protein-coding transcripts.
}
\examples{
library(BSgenome.Hsapiens.UCSC.hg19)
library(GenomeInfoDb)  # for seqlevelsStyle()
seqlevelsStyle(Hsapiens) <- "NCBI"
predictVariantEffects(sgv_pred, tx, Hsapiens)
}
\author{
Leonard Goldstein
}
