% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-transcription-rates-class.R
\name{rates}
\alias{rates}
\title{Accessor for estimated rates}
\usage{
rates(object)
}
\arguments{
\item{object}{A TranscriptionRates object}
}
\value{
A tibble containing the estimated rates
}
\description{
Generic accessor for the estimated rates from any TranscriptionRates object
}
\examples{
# Create an ExperimentTranscriptionRates object
load(system.file("extdata", 
"granges_for_read_counting_DLD1_chr21.RData", package = "STADyUM"))
expRates <- estimateTranscriptionRates(system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_plus_chr21.bw", package = "STADyUM"),
bigwigMinus = system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_minus_chr21.bw", package = "STADyUM"),
    pauseRegions = bw_pause_filtered,
    geneBodyRegions = bw_gb_filtered,
    name = "Control",
    stericHindrance = TRUE,
    omegaScale = 1000
)
rates(expRates)

}
