% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JPP_update.R
\name{JPP_update}
\alias{JPP_update}
\title{Select alternate m_score column in JPP data and avert user}
\usage{
JPP_update(data, mscore_col)
}
\arguments{
\item{data}{Data table that is produced by the OpenSWATH/pyProphet workflow}

\item{mscore_col}{Defines the column from which to retrieve the m_score. 
If you use JPP (Rosenberger, Bludau et al. 2017) this can be used to 
select between Protein and transition_group m_score.}
}
\value{
Returns the mscore_col that might have been changed to 
   transition_group_id_m_score and gives a message to the user.
}
\description{
The output from JPP (Rosenberger, Bludau et al. 2017) has not anymore the 
m_score column but an ProteinName_m_score and transition_group_id_m_score. 
To make the users aware this function tests if the m_score column still 
exists and selects as default the transition_group_id_m_score column.
}
\examples{
{
data("OpenSWATH_data", package="SWATH2stats")
JPP_update(OpenSWATH_data, "m_score")
}
}
\author{
Peter Blattmann
}
