% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_variation.R
\name{plot_variation}
\alias{plot_variation}
\title{Plots the coefficient of variation for different replicates.}
\usage{
plot_variation(
  data,
  column.values = "Intensity",
  comparison = transition_group_id + Condition ~ BioReplicate,
  fun_aggregate = NULL,
  label = FALSE,
  title = "cv across conditions",
  boxplot = TRUE,
  ...
)
}
\arguments{
\item{data}{Data frame that is produced by the OpenSWATH/pyProphet workflow.}

\item{column.values}{Indicates the columns for which the variation is
assessed. This can be the Intensity or Signal, but also the retention
time.}

\item{comparison}{The comparison for assessing the variability. Default is to
assess the variability per transition_group_id and Condition over the
different Replicates. Comparison is performed using the dcast() function of
the reshape2 package.}

\item{fun_aggregate}{If for the comparison values have to be aggregated one
needs to provide the function here.}

\item{label}{Option to print value of median cv.}

\item{title}{Title of plot. Default: "cv across conditions"}

\item{boxplot}{Logical. If boxplot should be plotted. Default: TRUE}

\item{...}{further arguments passed to method.}
}
\value{
Returns a list with the data and calculated cv and a table that
  summarizes the mean, median and mode cv per Condition (if Condition is
  contained in the comparison). In addition it plots in Rconsole a violin
  plot with the observed coefficient of variations.
}
\description{
This function plots the coefficient of variation within replicates for a
given value. If decoys are present these are removed before plotting.
}
\examples{
{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 var_summary <- plot_variation(data)
 }
}
\author{
Peter Blattmann
}
