% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{Img<-,SpatialExperiment-method}
\alias{Img<-,SpatialExperiment-method}
\alias{Img<-}
\title{Image setter}
\usage{
\S4method{Img}{SpatialExperiment}(x, sample_id = 1L, image_id, scale_fct = 1) <- value
}
\arguments{
\item{x}{A \code{SpatialExperiment} object, which includes SFE.}

\item{sample_id}{Which sample the image is associated with. Use
\code{\link{sampleIDs}} to get sample IDs present in the SFE object.}

\item{image_id}{Image ID, such as "lowres" and "hires" for Visium data and
"DAPI" and "PolyT" for Vizgen MERFISH data.}

\item{scale_fct}{Scale factor to convert pixels in lower resolution to those
in the full resolution. Only relevant to image classes implemented in
\code{SpatialExperiment} but not \code{SpatialFeatureExperiment} because
the spatial extent of images in SFE takes precedence.}

\item{value}{New version of image to add, must inherit from
\code{VirtualSpatialImage}.}
}
\value{
SFE object with the new image added.
}
\description{
Modify or replace images stored in a \code{SpatialExperiment} object. This is
different from \code{\link[SpatialExperiment]{addImg}} which adds the image from files and can't
replace existing images, which is there to be consistent with
\code{SpatialExperiment}. This setter here can replace existing images with
another object that inherits from \code{VirtualSpatialImage}, including
\code{\link{SpatRasterImage}}, \code{\link{BioFormatsImage}}, and
\code{\link{ExtImage}}.
}
\examples{
library(EBImage)
library(SFEData)
library(RBioFormats)
fp <- tempfile()
fn <- XeniumOutput("v2", file_path = fp)
# Weirdly the first time I get the null pointer error
try(sfe <- readXenium(fn))
sfe <- readXenium(fn)
img <- getImg(sfe) |> toExtImage(resolution = 1L)
img <- img[,,1] > 500
Img(sfe, image_id = "mask") <- img
imageIDs(sfe)
unlink(fn, recursive = TRUE)

}
\concept{Image methods}
