% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotGeometries.R
\name{annotGeometries}
\alias{annotGeometries}
\alias{annotGeometries<-}
\alias{annotGeometry}
\alias{annotGeometry<-}
\alias{annotGeometryNames}
\alias{annotGeometryNames<-}
\alias{annotGeometries,SpatialFeatureExperiment-method}
\alias{annotGeometries<-,SpatialFeatureExperiment-method}
\alias{annotGeometryNames,SpatialFeatureExperiment-method}
\alias{annotGeometryNames<-,SpatialFeatureExperiment,character-method}
\alias{annotGeometry,SpatialFeatureExperiment-method}
\alias{annotGeometry<-,SpatialFeatureExperiment-method}
\alias{tissueBoundary}
\alias{tissueBoundary<-}
\title{Annotation geometry methods}
\usage{
\S4method{annotGeometries}{SpatialFeatureExperiment}(x)

\S4method{annotGeometries}{SpatialFeatureExperiment}(x, translate = TRUE, ...) <- value

\S4method{annotGeometryNames}{SpatialFeatureExperiment}(x)

\S4method{annotGeometryNames}{SpatialFeatureExperiment,character}(x) <- value

\S4method{annotGeometry}{SpatialFeatureExperiment}(x, type = 1L, sample_id = NULL)

\S4method{annotGeometry}{SpatialFeatureExperiment}(x, type = 1L, sample_id = NULL, translate = TRUE, ...) <- value

tissueBoundary(x, sample_id = 1L)

tissueBoundary(x, sample_id = 1L, translate = TRUE, ...) <- value
}
\arguments{
\item{x}{A \code{SpatialFeatureExperiment} object.}

\item{translate}{Logical. Only used if \code{\link{removeEmptySpace}} has
been run of the SFE object. If that's the case, this argument indicates
whether the new value to be assigned to the geometry is in the coordinates
prior to removal of empty space so it should be translated to match the new
coordinates after removing empty space. Default to \code{TRUE}.}

\item{...}{\code{spatialCoordsNames, spotDiameter, geometryType} passed to
\code{\link{df2sf}}. Defaults are the same as in \code{\link{df2sf}}. For
\code{dimGeometries<-} only: \code{geometryType} can be a character vector
of the geometry type of each data frame in the list of the same length as
the list if the data frames specify different types of geometries.}

\item{value}{Value to set. For \code{annotGeometry}, must be a \code{sf} data
frame, or an ordinary data frame that can be converted to a \code{sf} data
frame (see \code{\link{df2sf}}). For \code{annotGeometries}, must be a list
of such \code{sf} or ordinary data frames. There must be a column
\code{sample_id} to indicate the sample the geometries are for, and the
\code{sample_id} must also appear in \code{colData}.}

\item{type}{An integer specifying the index or string specifying the name of
the *Geometry to query or replace. If missing, then the first item in the
*Geometries will be returned or replaced.}

\item{sample_id}{Sample ID to get or set geometries.}
}
\value{
Getters for multiple geometries return a named list. Getters for
  names return a character vector of the names. Getters for single geometries
  return an \code{sf} data frame. Setters return an SFE object.
}
\description{
"Annotation geometry" refers to Simple Feature (\code{sf}) geometries NOT
associated with rows (features, genes) or columns (cells or spots) of the
gene count matrix in the \code{SpatialFeatureExperiment} object. So there can
be any number of rows in the \code{sf} data frame specifying the geometry.
Examples of such geometries are tissue boundaries, pathologist annotation of
histological regions, and objects not characterized by columns of the gene
count matrix (e.g. nuclei segmentation in a Visium dataset where the columns
are Visium spots). This page documents getters and setters for the annotation
geometries. Internally, annotation geometries are stored in
\code{int_metadata}.
}
\details{
Wrapper for getter and setter of special geometry: \describe{
\item{tisseuBoundary}{Boundary of the tissue of interest, including holes.
This is usually of geometry type MULTIPOLYGON, though geometries in
\code{annotGeometries} can have any type supported by \code{sf}.} }
}
\examples{
# Example dataset
library(SFEData)
sfe_small <- McKellarMuscleData(dataset = "small")

# Get all annotation geometries, returning a named list
annotGeometries(sfe_small)

# Set all annotation geometries, in a named list
toy <- readRDS(system.file("extdata/sfe_toy.rds",
    package = "SpatialFeatureExperiment"
))
ag <- readRDS(system.file("extdata/ag.rds",
    package = "SpatialFeatureExperiment"
))
annotGeometries(toy) <- list(hull = ag)

# Get names of annotation geometries
annotGeometryNames(sfe_small)

# Set names of annotation geometries
annotGeometryNames(toy) <- "foo"

# Get a specific annotation geometry by name
# sample_id is optional when there is only one sample present
nuclei <- annotGeometry(sfe_small, type = "nuclei", sample_id = "Vis5A")

# Get a specific annotation geometry by index
tb <- annotGeometry(sfe_small, type = 1L)

# Set a specific annotation geometry
annotGeometry(sfe_small, type = "nuclei2") <- nuclei

# Special convenience function for tissue boundaries
# Getter
tb <- tissueBoundary(sfe_small, sample_id = "Vis5A")
# Setter
tissueBoundary(sfe_small, sample_id = "Vis5A") <- tb
}
\concept{Getters and setters}
