% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureData.R
\name{getParams}
\alias{getParams}
\title{Get parameters used in spatial methods}
\usage{
getParams(
  sfe,
  name,
  local = FALSE,
  colData = FALSE,
  colGeometryName = NULL,
  annotGeometryName = NULL,
  reducedDimName = NULL
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{name}{Name used to store the results.}

\item{local}{Logical, whether the results of interest come from a local
spatial method.}

\item{colData}{Logical, whether the results were computed for a column of
\code{colData(sfe)}.}

\item{colGeometryName}{To get results for a \code{colGeometry}.}

\item{annotGeometryName}{To get results for an \code{annotGeometry};
\code{colGeometry} has precedence so this argument is ignored if
\code{colGeometryName} is specified.}

\item{reducedDimName}{Name of a dimension reduction, can be seen in
\code{\link[SingleCellExperiment]{reducedDimNames}}. \code{colGeometryName} and
\code{annotGeometryName} have precedence over \code{reducedDimName}.}
}
\value{
A named list showing the parameters
}
\description{
The \code{getParams} function allows users to access the parameters used to
compute the results that may be stored in \code{\link{colFeatureData}}.
}
\examples{
library(SFEData)
library(scater)
library(Voyager)
sfe <- McKellarMuscleData("small")
colGraph(sfe, "visium") <- findVisiumGraph(sfe)
sfe <- colDataMoransI(sfe, "nCounts")
getParams(sfe, "moran", colData = TRUE)
}
\concept{Getters and setters}
