% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Structstrings-DotBracketString.R,
%   R/Structstrings-DotBracketStringSet.R,
%   R/Structstrings-DotBracketStringSetList.R, R/Structstrings-alphabet.R
\docType{class}
\name{DotBracketString}
\alias{DotBracketString}
\alias{DotBracketStringSet}
\alias{DotBracketStringSetList}
\alias{DotBracketString-class}
\alias{DB}
\alias{DotBracketStringSet-class}
\alias{DBS}
\alias{DotBracketStringSetList-class}
\alias{DBSL}
\alias{alphabet,DotBracketString-method}
\alias{encoding,DotBracketString-method}
\title{The DotBracketString, DotBracketStringSet and DotBracketStringSetList
classes}
\usage{
DotBracketString(x = "", start = 1, nchar = NA)

DB(x = character(), start = 1, nchar = NA)

DotBracketStringSet(x = character())

DBS(x = character())

DotBracketStringSetList(..., use.names = TRUE)

DBSL(..., use.names = TRUE)

\S4method{alphabet}{DotBracketString}(x)

\S4method{encoding}{DotBracketString}(x)
}
\arguments{
\item{x}{\code{DotBracketString},\code{DotBracketStringSet}: the input, which
is tried to be convert into a \code{DotBracketString*}.}

\item{start}{\code{DotBracketString}: starting position for creating the 
object from the character input.}

\item{nchar}{\code{DotBracketString}: number of letters are read from the 
input character}

\item{...}{\code{DotBracketStringSetList}: the input, which converted into a
list. Each element is tried to be converted into a 
\code{DotBracketStringSet}.}

\item{use.names}{\code{DotBracketStringSetList}: Should names of the input be
preserved.}
}
\value{
a \code{DotBracketString*} object.
}
\description{
The \code{DotBracketString} extends the 
\code{\link[Biostrings:XStringSet-class]{BString}} class. The 
\code{DotBracketStringSet} and \code{DotBracketStringSetList} classes are 
implemented accordingly.

The alphabet consists of the letters
\code{(}, \code{)}, \code{.}, \code{<}, \code{>}, \code{[}, \code{]},
\code{\{} and \code{\}}, which describes base pairing between positions. The
\code{.} letter describes an unpaired position. The number of opening and
closing letters need to be equal within a \code{DotBracketString} to be a
valid dot bracket annotation. This is checked upon creation and modificiation
of the object.

The objects can also be created using the shorter function names \code{DB},
\code{DBS} and \code{DBSL}.

Currently, there is no distinction in base pairing strength between the
different bracket types.
}
\examples{
str <- "((.))..[[..]]...{{..}}..<<..>>"
db <- DotBracketString(str)
dbs <- DotBracketStringSet(c("structure1" = str, "structure2" = str))
dbsl <- DotBracketStringSetList(list(first = dbs, second = dbs))
}
