% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Enrichment.R
\name{Enrichment}
\alias{Enrichment}
\title{Enrichment function}
\usage{
Enrichment(
  dfList,
  enrich.databases = c("GO_Biological_Process_2021", "GO_Cellular_Component_2021",
    "GO_Molecular_Function_2021", "KEGG_2021_Human", "MSigDB_Hallmark_2020",
    "WikiPathways_2016", "BioCarta_2016", "Jensen_TISSUES", "Jensen_COMPARTMENTS",
    "Jensen_DISEASES"),
  p_adj = 0.05,
  logFC = 1,
  save.results = FALSE
)
}
\arguments{
\item{dfList}{Dataframes list}

\item{enrich.databases}{Vector of EnrichR databases to consult}

\item{p_adj}{Double. Adjusted pvalue threshold for the enrichment}

\item{logFC}{Double. Fold change threshold for the enrichment}

\item{save.results}{Logical. If TRUE saves input gene lists and enrichment results.}
}
\value{
A list of enrichment tables for upregulated and downregulated genes
in the different enrichr databases
}
\description{
Perform enrichment Analysis of RNA-Seq Data
}
\examples{
\dontrun{
df1 <- data.frame(GeneID  = c("MEST", "CDK1", "PCLAF", "BIRC5"),
                  baseMean = c(13490.22, 10490.23, 8888.33, 750.33),
                  log2FoldChange = c(5.78, 6.76, -7.78, -8.78),
                  padj = c(2.28e-143, 2.18e-115, 2.18e-45, 0.006),
                  row.names = c("MEST", "CDK1", "PCLAF", "BIRC5"))
df2 <- data.frame(GeneID  = c("MEST", "CDK1", "PCLAF", "BIRC5"),
                  baseMean = c(13490.22, 10490.23, 8888.33, 750.33),
                  log2FoldChange = c(5.78, 6.76, -7.78, -8.78),
                  padj = c(2.28e-143, 2.18e-115, 2.18e-45, 0.006),
                  row.names = c("MEST", "CDK1", "PCLAF", "BIRC5"))
dfList <- list(df1 = df1, df2 = df2)
test <- Enrichment(dfList, enrich.databases = c("GO_Cellular_Component_2021"),
                   save.results = FALSE)}
}
\seealso{
\url{https://maayanlab.cloud/Enrichr/} for additional information about enrichR.

Other functional-annotation functions: 
\code{\link{Annotate_SPID}()},
\code{\link{Enrichment_barplot}()}
}
\concept{functional-annotation functions}
